/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import java.util.HashMap;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointXMLCodec;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpointType;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.xml.sax.Attributes;

class BreakpointsXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private BreakpointBag bag;
    private static final String TAG_BREAKPOINTS = "breakpoints";
    private final HashMap<String, BreakpointType> types = new HashMap();

    public BreakpointsXMLCodec(BreakpointBag bag) {
        this.bag = bag;
        this.initializeTypeLookup();
        this.registerXMLDecoder(new BreakpointXMLCodec(bag, null, this.types));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTypeLookup() {
        List breakpointTypes = DebuggerManager.getDebuggerManager().lookup(null, BreakpointType.class);
        if (breakpointTypes != null) {
            List list = breakpointTypes;
            synchronized (list) {
                for (BreakpointType bt : breakpointTypes) {
                    String category = bt.getCategoryDisplayName();
                    if (!NativeBreakpointType.isOurs(category)) continue;
                    this.types.put(((NativeBreakpointType)bt).id(), bt);
                    this.types.put(bt.getTypeDisplayName(), bt);
                }
            }
        }
    }

    public String tag() {
        return TAG_BREAKPOINTS;
    }

    public void start(Attributes atts) throws VersionException {
        String what = "breakpoint list";
        int maxVersion = 1;
        this.checkVersion(atts, what, maxVersion);
    }

    public void end() {
    }

    public void startElement(String element, Attributes atts) {
    }

    public void endElement(String element, String currentText) {
    }

    private static int version() {
        return 1;
    }

    public void encode(XMLEncoderStream xes) {
        xes.elementOpen(TAG_BREAKPOINTS, BreakpointsXMLCodec.version());
        NativeBreakpoint[] breakpoints = this.bag.getBreakpoints();
        for (int bx = 0; bx < breakpoints.length; ++bx) {
            NativeBreakpoint b = breakpoints[bx];
            BreakpointXMLCodec encoder = new BreakpointXMLCodec(b);
            encoder.encode(xes);
        }
        xes.elementClose(TAG_BREAKPOINTS);
    }
}

