/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import java.util.Vector;

public class InterfaceTable {
    public static final int MAX_ENTRIES = 128;
    protected int lineNumber;
    protected ClassIdentifier classIdentifier;
    protected String className;
    protected Vector<Integer> indexVector;
    protected Vector<String> nameDescrVector;
    protected JCClass parentClass;
    protected JCClass resolvedTo;

    InterfaceTable(JCClass jCClass, ClassIdentifier classIdentifier, int n) {
        assert (classIdentifier != null) : "classIdentifier != null";
        this.parentClass = jCClass;
        this.classIdentifier = classIdentifier;
        this.lineNumber = n;
        this.indexVector = new Vector();
        this.nameDescrVector = new Vector();
    }

    InterfaceTable(JCClass jCClass, String string, int n) {
        assert (string != null) : "className != null";
        this.parentClass = jCClass;
        this.className = string;
        this.lineNumber = n;
        this.indexVector = new Vector();
        this.nameDescrVector = new Vector();
    }

    public void addInterfaceIndex(int n) {
        if (this.indexVector.size() >= 128) {
            Object[] objectArray = new Object[]{new Integer(this.lineNumber)};
            Msg.error("itable.0", objectArray);
        } else {
            this.indexVector.addElement(new Integer(n));
        }
    }

    public void addRemoteMethodInfo(String string, int n) {
        if (this.indexVector.size() >= 128) {
            Object[] objectArray = new Object[]{new Integer(this.lineNumber)};
            Msg.error("itable.0", objectArray);
        } else {
            this.indexVector.addElement(new Integer(n));
            this.nameDescrVector.addElement(string);
        }
    }

    public String getName() {
        return this.className;
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classIdentifier;
    }

    public JCClass getParentClass() {
        return this.parentClass;
    }

    public void resolve(JCClass jCClass) {
        assert (jCClass != null) : "c != null";
        this.resolvedTo = jCClass;
    }

    public JCClass resolve() {
        assert (this.resolvedTo != null) : "resolvedTo != null";
        return this.resolvedTo;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    public Vector<String> getNameDescrVector() {
        return this.nameDescrVector;
    }

    public Vector<Integer> getIndexVector() {
        return this.indexVector;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        int n = 0;
        if (this.isResolved()) {
            int n2 = this.resolvedTo.getRelocAddr();
            byArray[n++] = (byte)(n2 >> 8 & 0xFF);
            byArray[n++] = (byte)(n2 & 0xFF);
        } else {
            JCPackage jCPackage = this.parentClass.getParentPackage();
            PackageIdentifier object = this.classIdentifier.getPackageIdentifier();
            byArray[n++] = (byte)(jCPackage.getPackageToken(object) | 0x80);
            byArray[n++] = (byte)this.classIdentifier.getClassToken();
        }
        byArray[n++] = (byte)this.indexVector.size();
        for (Integer n2 : this.indexVector) {
            byArray[n++] = (byte)n2.intValue();
        }
        return byArray;
    }

    public byte[] remoteInterfaceToByteArray() {
        byte[] byArray = new byte[2];
        int n = 0;
        if (this.isResolved()) {
            int n2 = this.resolvedTo.getRelocAddr();
            byArray[n++] = (byte)(n2 >> 8 & 0xFF);
            byArray[n++] = (byte)(n2 & 0xFF);
        } else {
            JCPackage jCPackage = this.parentClass.getParentPackage();
            PackageIdentifier packageIdentifier = this.classIdentifier.getPackageIdentifier();
            byArray[n++] = (byte)(jCPackage.getPackageToken(packageIdentifier) | 0x80);
            byArray[n++] = (byte)this.classIdentifier.getClassToken();
        }
        return byArray;
    }

    public int size() {
        return 3 + this.indexVector.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".interfaceTable ");
        stringBuffer.append(this.classIdentifier != null ? this.classIdentifier.toString() : this.className);
        stringBuffer.append(" {" + Msg.eol);
        for (Integer n : this.indexVector) {
            stringBuffer.append(Msg.toHexString((byte)n.intValue()) + ";" + Msg.eol);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

