/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.fxml;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.javafx2.editor.fxml.Bundle;
import org.netbeans.modules.javafx2.editor.spi.FXMLOpener;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public class FXMLOpenAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup context;
    private Lookup.Result<DataObject> lkpInfo;
    private FXMLOpener opener;
    private FXMLOpener defaultOpener = new FXMLOpener(){

        @Override
        public boolean isEnabled(Lookup context) {
            return context.lookupAll(DataObject.class).size() == 1;
        }

        @Override
        public boolean open(Lookup context) {
            DataObject dobj = (DataObject)context.lookup(DataObject.class);
            OpenCookie oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
            if (oc != null) {
                oc.open();
                return true;
            }
            return false;
        }
    };

    public FXMLOpenAction() {
        this(Utilities.actionsGlobalContext());
    }

    public FXMLOpenAction(Lookup context) {
        this.context = context;
        this.putValue("Name", Bundle.CTL_OpenAction());
        this.putValue("hideWhenDisabled", true);
        this.setupOpener();
    }

    private void setupOpener() {
        this.opener = (FXMLOpener)Lookup.getDefault().lookup(FXMLOpener.class);
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        this.lkpInfo = this.context.lookupResult(DataObject.class);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    @Override
    public boolean isEnabled() {
        this.init();
        return this.opener != null && this.opener.isEnabled(this.context) && super.isEnabled();
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnabled(!this.lkpInfo.allInstances().isEmpty());
    }

    public Action createContextAwareInstance(Lookup context) {
        return new FXMLOpenAction(context);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isNewFile = Thread.currentThread().getStackTrace()[2].getFileName().equals("ProjectUtilities.java");
        if (this.opener != null && !isNewFile) {
            this.opener.open(this.context);
        } else if (this.defaultOpener.isEnabled(this.context)) {
            this.defaultOpener.open(this.context);
        }
    }
}

