/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model.ui;

import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.ws.runtime.config.TubeFactoryList;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.metro.model.ui.TubesProjectConfigPanel;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TubesConfigPanel
extends JPanel {
    private Project project;
    private TubeFactoryList tubeList;
    private boolean isChanged;
    private boolean client;
    private boolean overrideDefaults;
    private JButton addBtn;
    private JButton downBtn;
    private JScrollPane jScrollPane2;
    private JCheckBox overrideDefChBox;
    private JButton removeBtn;
    private JTable tubeTable;
    private DefaultTableModel tubeTableModel;
    private JButton upBtn;

    public TubesConfigPanel(Project project, TubeFactoryList tubeList, boolean client, boolean overrideDefault) {
        this.project = project;
        this.client = client;
        this.tubeList = tubeList;
        this.overrideDefaults = overrideDefault;
        this.initComponents();
        this.populateValues();
        this.addBtn.addActionListener(new AddButtonActionListener());
        this.removeBtn.addActionListener(new RemoveButtonActionListener());
        this.isChanged = false;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isOverride() {
        return this.overrideDefChBox.isSelected();
    }

    public List<String> getTubeList() {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < this.tubeTableModel.getRowCount(); ++i) {
            retList.add((String)this.tubeTableModel.getValueAt(i, 0));
        }
        return retList;
    }

    private void populateValues() {
        this.overrideDefChBox.setSelected(this.overrideDefaults);
        List<TubeFactoryConfig> tubeFacConfigs = this.tubeList.getTubeFactoryConfigs();
        for (TubeFactoryConfig cfg : tubeFacConfigs) {
            this.tubeTableModel.addRow(new Object[]{cfg.getClassName()});
        }
        if (this.tubeTableModel.getRowCount() > 0) {
            this.tubeTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.enableDisable();
    }

    private void initComponents() {
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tubeTable = new TubeTable();
        this.overrideDefChBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Add"));
        this.addBtn.setToolTipText(NbBundle.getMessage(TubesConfigPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Remove"));
        this.removeBtn.setToolTipText(NbBundle.getMessage(TubesConfigPanel.class, (String)"HINT_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.upBtn, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Move_Up"));
        this.upBtn.setToolTipText(NbBundle.getMessage(TubesConfigPanel.class, (String)"HINT_Move_Up"));
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TubesConfigPanel.this.moveUpHandler(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downBtn, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Move_Down"));
        this.downBtn.setToolTipText(NbBundle.getMessage(TubesConfigPanel.class, (String)"HINT_Move_Down"));
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TubesConfigPanel.this.moveDownHandler(evt);
            }
        });
        this.tubeTableModel = new TubeTableModel(new String[]{NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HEADING_TUBES")}, 0);
        this.tubeTable.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tubeTable.setModel(this.tubeTableModel);
        this.jScrollPane2.setViewportView(this.tubeTable);
        this.tubeTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TubesConfigPanel.class, (String)"ACSD_MessageHandlerTable"));
        this.tubeTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TubesConfigPanel.class, (String)"ACSD_MessageHandlerTable"));
        Mnemonics.setLocalizedText((AbstractButton)this.overrideDefChBox, (String)NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_OverrideDefaults"));
        this.overrideDefChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TubesConfigPanel.this.overrideDefChBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 332, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addBtn, -1, 190, Short.MAX_VALUE).addComponent(this.upBtn, -1, 190, Short.MAX_VALUE).addComponent(this.removeBtn, -1, 190, Short.MAX_VALUE).addComponent(this.downBtn, -1, 190, Short.MAX_VALUE))).addComponent(this.overrideDefChBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.overrideDefChBox).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.addBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBtn).addGap(23, 23, 23).addComponent(this.upBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downBtn)).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 187, Short.MAX_VALUE)).addContainerGap()));
        this.addBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TubesConfigPanel.class, (String)"LBL_Add"));
    }

    private void moveUpHandler(ActionEvent evt) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        int newSelectedRow = selectedRow - 1;
        this.tubeTableModel.moveRow(selectedRow, selectedRow, newSelectedRow);
        this.tubeTable.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
        this.isChanged = true;
    }

    private void moveDownHandler(ActionEvent evt) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        int newSelectedRow = selectedRow + 1;
        this.tubeTableModel.moveRow(selectedRow, selectedRow, newSelectedRow);
        this.tubeTable.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
        this.isChanged = true;
    }

    private void overrideDefChBoxActionPerformed(ActionEvent evt) {
        this.isChanged = true;
        this.enableDisable();
    }

    private void enableDisable() {
        boolean override = this.overrideDefChBox.isSelected();
        this.tubeTable.setEnabled(override);
        this.tubeTable.setFocusable(override);
        this.tubeTable.setOpaque(!override);
        this.addBtn.setEnabled(override);
        this.downBtn.setEnabled(override);
        this.jScrollPane2.setEnabled(override);
        this.removeBtn.setEnabled(override);
        this.upBtn.setEnabled(override);
    }

    private int getSelectedRow() {
        ListSelectionModel lsm = this.tubeTable.getSelectionModel();
        if (lsm.isSelectionEmpty()) {
            return -1;
        }
        return lsm.getMinSelectionIndex();
    }

    static class TubeTableModel
    extends DefaultTableModel {
        public TubeTableModel(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class TubeListSelectionListener
    implements ListSelectionListener {
        TubeListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selectedRow = TubesConfigPanel.this.getSelectedRow();
                if (selectedRow == 0) {
                    TubesConfigPanel.this.upBtn.setEnabled(false);
                } else if (!TubesConfigPanel.this.upBtn.isEnabled()) {
                    TubesConfigPanel.this.upBtn.setEnabled(true);
                }
                if (selectedRow == TubesConfigPanel.this.tubeTableModel.getRowCount() - 1) {
                    TubesConfigPanel.this.downBtn.setEnabled(false);
                } else if (!TubesConfigPanel.this.downBtn.isEnabled()) {
                    TubesConfigPanel.this.downBtn.setEnabled(true);
                }
            }
        }
    }

    class TubeTable
    extends JTable {
        public TubeTable() {
            JTableHeader header = this.getTableHeader();
            header.setResizingAllowed(false);
            header.setReorderingAllowed(false);
            ListSelectionModel model = this.getSelectionModel();
            model.setSelectionMode(1);
            model.addListSelectionListener(new TubeListSelectionListener());
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component comp = super.prepareRenderer(renderer, row, column);
            this.getTableHeader().setEnabled(this.isEnabled());
            comp.setEnabled(this.isEnabled());
            return comp;
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ClassDialog classDialog = new ClassDialog(TubesConfigPanel.this.project, null);
            classDialog.show();
            int newSelectedRow = 0;
            if (classDialog.okButtonPressed()) {
                Set selectedClasses = classDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    TubesConfigPanel.this.tubeTableModel.addRow(new Object[]{selectedClass});
                    newSelectedRow = TubesConfigPanel.this.tubeTableModel.getRowCount() - 1;
                }
            }
            TubesConfigPanel.this.tubeTable.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
            TubesConfigPanel.this.isChanged = true;
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = TubesConfigPanel.this.tubeTable.getSelectedRows();
            Arrays.sort(selectedRows);
            if (selectedRows == null || selectedRows.length <= 0) {
                return;
            }
            StringBuilder className = new StringBuilder();
            for (int i : selectedRows) {
                className.append((String)TubesConfigPanel.this.tubeTableModel.getValueAt(i, 0));
                className.append(", \n");
            }
            if (this.confirmDeletion(className.toString())) {
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    TubesConfigPanel.this.tubeTableModel.removeRow(i);
                }
                int newSelectedRow = selectedRows[0] - 1;
                TubesConfigPanel.this.tubeTable.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
                TubesConfigPanel.this.isChanged = true;
            }
        }

        private boolean confirmDeletion(String className) {
            NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TubesConfigPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)className), NbBundle.getMessage(TubesConfigPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
            return notifyDesc.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

