/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.support;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphScene;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportXmlAction
extends AbstractAction
implements Presenter.Popup {
    private static final String EXTENSION = "xml";
    private final CallGraphScene scene;
    private final JComponent parent;
    private final JMenuItem menuItem;

    public ExportXmlAction(CallGraphScene scene, JComponent parent) {
        this.scene = scene;
        this.parent = parent;
        this.putValue("Name", this.getString("ExportXmlAction"));
        this.menuItem = new JMenuItem(this);
        Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.print();
    }

    public final JMenuItem getPopupPresenter() {
        return this.menuItem;
    }

    private String getString(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print() {
        if (this.scene != null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(this.getString("ExportGraphAsXml"));
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new MyFileFilter());
            if (chooser.showSaveDialog(this.parent) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".xml")) {
                file = new File(file.getParentFile(), file.getName() + "." + EXTENSION);
            }
            if (file.exists()) {
                String message = this.getString("FileExistsMessage");
                DialogDescriptor descriptor = new DialogDescriptor((Object)MessageFormat.format(message, file.getAbsolutePath()), this.getString("FileExists"), true, 0, DialogDescriptor.NO_OPTION, null);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
                try {
                    dialog.setVisible(true);
                }
                catch (Throwable th) {
                    if (!(th.getCause() instanceof InterruptedException)) {
                        throw new RuntimeException(th);
                    }
                    descriptor.setValue(DialogDescriptor.CLOSED_OPTION);
                }
                finally {
                    dialog.dispose();
                }
                if (descriptor.getValue() != DialogDescriptor.YES_OPTION) {
                    return;
                }
            }
            try {
                Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element graphRoot = this.initXml(xmlDocument);
                for (Function func : this.scene.getNodes()) {
                    Element node = xmlDocument.createElement(Tag.NODE.toString());
                    node.setAttribute(TagAtribute.ID.toString(), func.getScopeName() + func.getName());
                    graphRoot.appendChild(node);
                }
                for (Call call : this.scene.getEdges()) {
                    Element edge = xmlDocument.createElement(Tag.EDGE.toString());
                    edge.setAttribute(TagAtribute.SOURCE.toString(), call.getCallee().getScopeName() + call.getCallee().getName());
                    edge.setAttribute(TagAtribute.TARGET.toString(), call.getCaller().getScopeName() + call.getCaller().getName());
                    graphRoot.appendChild(edge);
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xmlDocument);
                StreamResult result = new StreamResult(file);
                transformer.transform(source, result);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace(System.err);
            }
            catch (TransformerException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private Element initXml(Document xmlDocument) {
        Element rootElement = xmlDocument.createElement(Tag.GRAPHML.toString());
        rootElement.setAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
        rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttribute("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        xmlDocument.appendChild(rootElement);
        Element graphRoot = xmlDocument.createElement(Tag.GRAPH.toString());
        graphRoot.setAttribute(TagAtribute.ID.toString(), this.parent.getName());
        graphRoot.setAttribute(TagAtribute.EDGEDEFAULT.toString(), "directed");
        rootElement.appendChild(graphRoot);
        return graphRoot;
    }

    private static class MyFileFilter
    extends FileFilter {
        private MyFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(ExportXmlAction.class, (String)"GraphML");
        }
    }

    private static enum TagAtribute {
        ID("id"),
        SOURCE("source"),
        TARGET("target"),
        EDGEDEFAULT("edgedefault");

        private final String attr;

        private TagAtribute(String attr) {
            this.attr = attr;
        }

        public String toString() {
            return this.attr;
        }
    }

    private static enum Tag {
        GRAPHML("graphml"),
        GRAPH("graph"),
        NODE("node"),
        EDGE("edge");

        private final String tag;

        private Tag(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }
    }
}

