Changes in 3.0.4 (2020-12-31)
-----------------------------

This release contains a fix for [Chromium bug 1158070][crbug1158070]. Also
upstreamed some local patches to the WebRTC project (CLs
[198241][webrtccl198241] and [198362][webrtccl198362]).

Changes in 3.0.3 (2020-12-18)
-----------------------------

Made `WebRtcIlbcfix_InitDecode` an exported symbol on shared library builds.
([#32]) Thanks again to Daniel Bermond <danielbermond@gmail.com> for noticing
this.

Changes in 3.0.2 (2020-12-18)
-----------------------------

Fixed installation from out-of-tree builds. ([#28]) Thanks to Daniel Bermond
<danielbermond@gmail.com>.

Changes in 3.0.1 (2020-12-18)
-----------------------------

Fixed source code packaging.

Changes in 3.0.0 (2020-12-18)
-----------------------------

This version of libilbc brings the latest updates from upstream WebRTC code.
The API is mostly compatible, but has a few cosmetic changes that may
nevertheless require users to adapt. Users can use the new
`LIBILBC_VERSION_MAJOR` macro to distinguish this release from previous
releases. The ABI is not compatible, and the SONAME version has been
incremented to 3.0.0.

### Breaking changes

- Various data structures have been renamed. The original names are kept as
  typedef'd aliases, but users are encouraged to switch to the new naming
  scheme.
  ```
  iLBC_encinst_t  → IlbcEncoderInstance
  iLBC_decinst_t  → IlbcDecoderInstance
  iLBC_Enc_Inst_t → IlbcEncoder
  iLBC_Dec_Inst_t → IlbcDecoder
  ```

- Some deprecated macros for RFC 3951 compatibility has now been removed. You
  can restore them with:
  ```c
  #define initDecode WebRtcIlbcfix_InitDecode
  #define initEncode WebRtcIlbcfix_InitEncode
  #define iLBC_decode WebRtcIlbcfix_DecodeImpl
  #define iLBC_encode WebRtcIlbcfix_EncodeImpl
  ```

- Many length-like parameters now use the `size_t` type. The following
  functions and structs are affected:

  * `WebRtcIlbcfix_Encode`
  * `WebRtcIlbcfix_Decode`
  * `WebRtcIlbcfix_Decode20Ms`
  * `WebRtcIlbcfix_Decode30Ms`
  * `WebRtcIlbcfix_DecodePlc`
  * `WebRtcIlbcfix_NetEqPlc`
  * `IlbcEncoder` (né `iLBC_Enc_Inst_t`) fields
    * `blockl`
    * `nsub`
    * `no_of_bytes, no_of_words`
    * `state_short_len`
  * `IlbcDecoder` (né `iLBC_Dec_Inst_t`) fields
    * `blockl`
    * `nsub`
    * `no_of_bytes, no_of_words`
    * `state_short_len`
    * `last_lag`
    * `prevLag`
    * `enh_period`

- To remove duplicated work, the Autotools build system has been removed. CMake
  is now the only option.

### Other changes

- Update to latest WebRTC source (r32829, cf8ec1f686).

- A new program that allows testing this library is now compiled and installed:
  ilbc\_test. See the README for some hints on how to use it.

- A new header is now shipped: ilbc\_export.h. Users should never have to
  interact with it though.

- ilbc.h now includes version macros:
  ```c
  #define LIBILBC_VERSION_MAJOR 3
  #define LIBILBC_VERSION_MINOR 0
  #define LIBILBC_VERSION_PATCH 0
  ```

- New CI has been created using GitHub Actions, covering many platforms:
   - Ubuntu x86-64 (Ninja and GNU Make)
   - macOS x86-64 (Ninja and GNU Make)
   - Windows x86-64 (Visual Studio)
   - Ubuntu aarch64, armel, armhf, mipsel, mips64el, ppc, ppc64, ppc64le,
     riscv64, sparc64 (cross-compiled)
   - Windows ARM64 (cross-compiled)

Changes in 2.0.2 (2014-12-14)
-----------------------------

- Distribute config.h.cmakein in the release tarball (fixes #14).
- Distribute and install README.md and NEWS.md.
- Miscellanneous distribution improvements.
- Bump shared lib name generated by autotools to libilbc.so.2.0.2 to be
  consistent with the CMake toolchain.

Changes in 2.0.1 (2014-12-11)
-----------------------------

- Update to r7765, cc7755b.
- Fix crash in programs directly calling Init functions, without first
  creating a context through constructors.
- Proper SONAME versioning added, and bumped to libilbc.so.2.

Changes in 2.0.0 (2014-11-17)
-----------------------------

- Under new maintainership by me (Timothy Gu).
- Update to latest upstream source (r7715, 087da13).
  - A threading implementation is now needed. Win32 and POSIX Threads are
    supported.
- Autotools files are cleaned-up.
- CMake now uses BUILD\_SHARED\_LIBS to determine the type of library to build.
- CMake installation paths on some 64-bit systems using `lib64/` are
  corrected.
- Git metadata for merging from upstream is added for easier merging.
- Travis CI support is added.

[#28]: https://github.com/TimothyGu/libilbc/issues/28
[#32]: https://github.com/TimothyGu/libilbc/issues/32
[crbug1158070]: https://crbug.com/1158070
[webrtccl198241]: https://webrtc-review.googlesource.com/c/src/+/198241
[webrtccl198362]: https://webrtc-review.googlesource.com/c/src/+/198362
