/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.EnumClassLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorBodyTransformer;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "lowerEnumConstructorsBody", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "lowerEnumEntryClassConstructors", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "entry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "lowerEnumEntryInitializerExpression", "IrEnumClassConstructorTransformer", "IrEnumEntryClassConstructorTransformer", "backend.js"})
public final class EnumClassConstructorBodyTransformer
implements BodyLoweringPass {
    @NotNull
    private final JsCommonBackendContext context;

    public EnumClassConstructorBodyTransformer(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        block4: {
            Intrinsics.checkNotNullParameter(irBody, "irBody");
            Intrinsics.checkNotNullParameter(container, "container");
            IrDeclarationParent irDeclarationParent = container.getParent();
            IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            if (irClass == null) break block4;
            IrClass irClass2 = irClass;
            boolean bl = false;
            EnumClassLoweringKt.access$fixReferencesToConstructorParameters(this.context, irClass2, irBody);
            if (container instanceof IrConstructor) {
                if (IrJsUtilsKt.isInstantiableEnum(irClass2)) {
                    this.lowerEnumConstructorsBody((IrConstructor)container);
                }
                IrEnumEntry irEnumEntry = JsIrAttributesKt.getCorrespondingEnumEntry(irClass2);
                if (irEnumEntry != null) {
                    IrEnumEntry enumEntry = irEnumEntry;
                    boolean bl2 = false;
                    this.lowerEnumEntryClassConstructors(IrUtilsKt.getParentAsClass(enumEntry), enumEntry, (IrConstructor)container);
                }
            }
            if (container instanceof IrEnumEntry) {
                this.lowerEnumEntryInitializerExpression(irClass2, (IrEnumEntry)container);
            }
        }
    }

    private final void lowerEnumConstructorsBody(IrConstructor constructor) {
        new IrEnumClassConstructorTransformer(constructor).transformBody();
    }

    private final void lowerEnumEntryClassConstructors(IrClass irClass, IrEnumEntry entry, IrConstructor constructor) {
        IrElementTransformerVoidKt.transformChildrenVoid(constructor, new IrEnumEntryClassConstructorTransformer(irClass, entry, true));
    }

    private final void lowerEnumEntryInitializerExpression(IrClass irClass, IrEnumEntry entry) {
        IrExpressionBody irExpressionBody = entry.getInitializerExpression();
        entry.setInitializerExpression((IrExpressionBody)(irExpressionBody != null ? irExpressionBody.transform((IrTransformer)new IrEnumEntryClassConstructorTransformer(irClass, entry, false), (Object)null) : null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorBodyTransformer$IrEnumClassConstructorTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorBodyTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)V", "getConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getBuilder", "()Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "transformBody", "", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorBodyTransformer$IrEnumClassConstructorTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,585:1\n1#2:586\n*E\n"})
    private final class IrEnumClassConstructorTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrConstructor constructor;
        @NotNull
        private final DeclarationIrBuilder builder;

        public IrEnumClassConstructorTransformer(IrConstructor constructor) {
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            this.constructor = constructor;
            this.builder = LowerUtilsKt.createIrBuilder$default(EnumClassConstructorBodyTransformer.this.getContext(), (IrSymbol)this.constructor.getSymbol(), 0, 0, 6, null);
        }

        @NotNull
        public final IrConstructor getConstructor() {
            return this.constructor;
        }

        @NotNull
        public final DeclarationIrBuilder getBuilder() {
            return this.builder;
        }

        public final void transformBody() {
            block0: {
                IrBody irBody = this.constructor.getBody();
                if (irBody == null) break block0;
                IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
            }
        }

        @Override
        @NotNull
        public IrDelegatingConstructorCall visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrDelegatingConstructorCall $this$visitEnumConstructorCall_u24lambda_u240 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall(this.builder, (IrConstructor)expression2.getSymbol().getOwner());
            boolean bl = false;
            for (int i2 = 0; i2 < 2; ++i2) {
                $this$visitEnumConstructorCall_u24lambda_u240.getArguments().set(i2, ExpressionHelpersKt.irGet(this.builder, this.constructor.getParameters().get(i2)));
            }
            AddToStdlibKt.assignFrom($this$visitEnumConstructorCall_u24lambda_u240.getTypeArguments(), (Iterable)expression2.getTypeArguments());
            return irDelegatingConstructorCall;
        }

        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrConstructor it = (IrConstructor)expression2.getSymbol().getOwner();
            boolean bl = false;
            IrConstructor irConstructor = JsIrAttributesKt.getNewEnumConstructor(it);
            if (irConstructor == null) {
                irConstructor = it;
            }
            IrConstructor delegatingConstructor = irConstructor;
            IrDelegatingConstructorCall $this$visitDelegatingConstructorCall_u24lambda_u242 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall(this.builder, delegatingConstructor);
            boolean bl2 = false;
            int valueArgIdx = 0;
            for (int i2 = 0; i2 < 2; ++i2) {
                $this$visitDelegatingConstructorCall_u24lambda_u242.getArguments().set(valueArgIdx++, ExpressionHelpersKt.irGet(this.builder, this.constructor.getParameters().get(i2)));
            }
            Iterator iterator2 = expression2.getArguments().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                IrExpression argument = (IrExpression)iterator3.next();
                $this$visitDelegatingConstructorCall_u24lambda_u242.getArguments().set(valueArgIdx++, argument);
            }
            AddToStdlibKt.assignFrom($this$visitDelegatingConstructorCall_u24lambda_u242.getTypeArguments(), (Iterable)expression2.getTypeArguments());
            return irDelegatingConstructorCall;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0005H\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorBodyTransformer$IrEnumEntryClassConstructorTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "entry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "isInsideConstructor", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorBodyTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;Z)V", "getEntry", "()Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "()Z", "enumEntries", "", "getNameExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "getOrdinalExpression", "buildConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "backend.js"})
    private final class IrEnumEntryClassConstructorTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrEnumEntry entry;
        private final boolean isInsideConstructor;
        @NotNull
        private final List<IrEnumEntry> enumEntries;

        public IrEnumEntryClassConstructorTransformer(@NotNull IrClass irClass, IrEnumEntry entry, boolean isInsideConstructor) {
            Intrinsics.checkNotNullParameter(irClass, "irClass");
            Intrinsics.checkNotNullParameter(entry, "entry");
            this.entry = entry;
            this.isInsideConstructor = isInsideConstructor;
            this.enumEntries = EnumClassLoweringKt.access$getEnumEntries(irClass);
        }

        @NotNull
        public final IrEnumEntry getEntry() {
            return this.entry;
        }

        public final boolean isInsideConstructor() {
            return this.isInsideConstructor;
        }

        private final IrConst getNameExpression(IrEnumEntry $this$getNameExpression) {
            return IrUtilsKt.toIrConst$default($this$getNameExpression.getName().getIdentifier(), EnumClassConstructorBodyTransformer.this.getContext().getIrBuiltIns().getStringType(), 0, 0, 6, null);
        }

        private final IrConst getOrdinalExpression(IrEnumEntry $this$getOrdinalExpression) {
            return IrUtilsKt.toIrConst$default(this.enumEntries.indexOf($this$getOrdinalExpression), EnumClassConstructorBodyTransformer.this.getContext().getIrBuiltIns().getIntType(), 0, 0, 6, null);
        }

        private final IrFunctionAccessExpression buildConstructorCall(IrConstructor constructor, IrEnumConstructorCall constructorCall) {
            return this.isInsideConstructor ? (IrFunctionAccessExpression)JsIrBuilder.buildDelegatingConstructorCall$default(JsIrBuilder.INSTANCE, constructor.getSymbol(), null, constructorCall.getStartOffset(), constructorCall.getEndOffset(), 2, null) : (IrFunctionAccessExpression)JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, constructor.getSymbol(), null, null, null, constructorCall.getStartOffset(), constructorCall.getEndOffset(), 14, null);
        }

        @Override
        @NotNull
        public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            IrFunctionAccessExpression irFunctionAccessExpression;
            boolean constructorWasTransformed;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
            boolean bl = constructorWasTransformed = JsIrAttributesKt.getNewEnumConstructor(constructor) != null;
            if (constructorWasTransformed) {
                IrConstructor irConstructor = JsIrAttributesKt.getNewEnumConstructor(constructor);
                Intrinsics.checkNotNull(irConstructor);
                constructor = irConstructor;
            }
            IrFunctionAccessExpression $this$visitEnumConstructorCall_u24lambda_u240 = irFunctionAccessExpression = this.buildConstructorCall(constructor, expression2);
            boolean bl2 = false;
            int valueArgIdx = 0;
            if (constructorWasTransformed) {
                $this$visitEnumConstructorCall_u24lambda_u240.getArguments().set(valueArgIdx++, this.getNameExpression(this.entry));
                $this$visitEnumConstructorCall_u24lambda_u240.getArguments().set(valueArgIdx++, this.getOrdinalExpression(this.entry));
            }
            Iterator iterator2 = expression2.getArguments().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                IrExpression argument = (IrExpression)iterator3.next();
                $this$visitEnumConstructorCall_u24lambda_u240.getArguments().set(valueArgIdx++, argument);
            }
            return irFunctionAccessExpression;
        }
    }
}

