/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import HTTPClient.Cookie;
import HTTPClient.CookieModule;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PostChangeLog
extends Task {
    public void execute() throws BuildException {
        PropertiesFile changeProps = new PropertiesFile("postchangelog");
        PropertiesFile defaultProps = new PropertiesFile("defaults");
        boolean active = changeProps.getBooleanProperty("active", false);
        if (!active) {
            System.out.println("Not active");
            return;
        }
        int siteBetaBuild = changeProps.getIntProperty("siteBetaBuild", 0);
        String currentBuildS = defaultProps.getProperty("version");
        Pattern buildPattern = Pattern.compile(".*-b(\\d*)");
        Matcher m = buildPattern.matcher(currentBuildS);
        if (!m.matches()) {
            System.out.println("Not a beta build");
            return;
        }
        int currentBetaBuild = Integer.parseInt(m.group(1));
        if (currentBetaBuild == siteBetaBuild) {
            System.out.println("Current and site beta builds are the same: nothing to do");
            return;
        }
        try {
            Pattern header = Pattern.compile("([0-9\\-])\\s*(.*)\\s*<(.*)> \\((.*)\\)");
            Object date = null;
            Object author = null;
            Object email = null;
            String version = null;
            StringBuffer changes = new StringBuffer();
            changes.append("Changes between b").append(siteBetaBuild).append(" and b").append(currentBetaBuild).append(": ");
            File changeLog = new File("ChangeLog");
            BufferedReader in = new BufferedReader(new FileReader(changeLog));
            String line = null;
            while ((line = in.readLine()) != null) {
                System.out.println("Got line: " + line);
                m = header.matcher(line);
                if (m.matches()) {
                    version = m.group(4);
                    System.out.println("Got a header. Version: " + version);
                    m = buildPattern.matcher(version);
                    if (m.matches()) {
                        int myBetaBuild = Integer.parseInt(m.group(1));
                        System.out.println("Beta version: " + myBetaBuild);
                        if (myBetaBuild != siteBetaBuild) continue;
                        System.out.println("Found the right beta: stopping");
                        break;
                    }
                    System.out.println("Found a non-beta... guess it stops here");
                    break;
                }
                if ((line = line.trim()).length() <= 0) continue;
                if (line.startsWith("*")) {
                    changes.append("\\n").append(line).append(" ");
                    continue;
                }
                changes.append(line.trim()).append(" ");
            }
            System.out.println("Got changes: " + changes);
            StringBuffer betaCheck = new StringBuffer();
            betaCheck.append("version=").append(currentBuildS).append("\n");
            betaCheck.append("releaseDate=").append(defaultProps.getProperty("releaseDate")).append("\n");
            betaCheck.append("releaseUrl=http://jpmullan.com/galleryupdates/remote/gallery_remote_").append(defaultProps.getProperty("version")).append(".zip\n");
            betaCheck.append("releaseUrlMac=http://jpmullan.com/galleryupdates/remote/GalleryRemote.").append(defaultProps.getProperty("version")).append(".MacOSX.NoVM.tgz\n");
            betaCheck.append("releaseNotes=").append(changes);
            System.out.println("Uploading to Menalto: " + betaCheck);
            NVPair[] form_data = new NVPair[]{new NVPair("op", "modload"), new NVPair("name", "GalleryRemoteVersion"), new NVPair("file", "index"), new NVPair("action", "save-beta"), new NVPair("newVersion", betaCheck.toString())};
            CookieModule.setCookiePolicyHandler((CookiePolicyHandler)new CookiePolicyHandler(){

                public boolean acceptCookie(Cookie cookie, RoRequest req, RoResponse resp) {
                    System.out.println("Accepting cookie: " + cookie);
                    return true;
                }

                public boolean sendCookie(Cookie cookie, RoRequest req) {
                    System.out.println("Sending cookie: " + cookie);
                    return true;
                }
            });
            HTTPConnection mConnection = new HTTPConnection("gallery.menalto.com");
            HTTPResponse rsp = null;
            String response = null;
            rsp = mConnection.Get("/user.php?uname=" + changeProps.getProperty("username") + "&pass=" + changeProps.getProperty("password") + "&module=NS-User&op=login");
            response = new String(rsp.getData()).trim();
            System.out.println("Login response: " + response);
            rsp = mConnection.Post("/modules.php", form_data);
            response = new String(rsp.getData()).trim();
            System.out.println("Upload response: " + response);
            if (response.startsWith("version=" + currentBuildS)) {
                System.out.println("Success: writing to postlogchange properties");
                changeProps.setIntProperty("siteBetaBuild", currentBetaBuild);
                changeProps.write();
            } else {
                System.out.println("Failed to update Menalto");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ModuleException e) {
            e.printStackTrace();
        }
    }
}

