/*
 * Decompiled with CFR 0.152.
 */
package ints;

import java.util.Arrays;

public class SynchedIntList {
    public static final int DEFAULT_INIT_CAPACITY = 16;
    private int size;
    private int[] values;

    public SynchedIntList() {
        this(16);
    }

    public SynchedIntList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.size = 0;
        this.values = new int[n];
    }

    public SynchedIntList(int[] nArray) {
        this.size = nArray.length;
        this.values = (int[])nArray.clone();
    }

    public SynchedIntList(SynchedIntList synchedIntList) {
        this.size = synchedIntList.size();
        this.values = Arrays.copyOf(synchedIntList.values, synchedIntList.size());
    }

    public synchronized void add(int n) {
        if (this.size == this.values.length) {
            int n2 = this.values.length * 3 / 2 + 1;
            this.values = Arrays.copyOf(this.values, n2);
        }
        this.values[this.size++] = n;
    }

    public synchronized int get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.values[n];
    }

    public synchronized int set(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n3 = this.values[n];
        this.values[n] = n2;
        return n3;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized int[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    public synchronized void clear() {
        this.size = 0;
    }

    public synchronized String toString() {
        return Arrays.toString(this.toArray());
    }
}

