/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mp4.Mp4Context;
import com.drew.metadata.mp4.Mp4Directory;
import com.drew.metadata.mp4.Mp4HandlerFactory;
import com.drew.metadata.mp4.boxes.Box;
import com.drew.metadata.mp4.boxes.FileTypeBox;
import com.drew.metadata.mp4.boxes.HandlerBox;
import com.drew.metadata.mp4.boxes.MediaHeaderBox;
import com.drew.metadata.mp4.boxes.MovieHeaderBox;
import com.drew.metadata.mp4.boxes.TrackHeaderBox;
import com.drew.metadata.mp4.media.Mp4UuidBoxHandler;
import java.io.IOException;

public class Mp4BoxHandler
extends Mp4Handler<Mp4Directory> {
    private Mp4HandlerFactory handlerFactory = new Mp4HandlerFactory(this);

    public Mp4BoxHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    @NotNull
    protected Mp4Directory getDirectory() {
        return new Mp4Directory();
    }

    @Override
    public boolean shouldAcceptBox(@NotNull Box box) {
        return box.type.equals("ftyp") || box.type.equals("mvhd") || box.type.equals("hdlr") || box.type.equals("mdhd") || box.type.equals("tkhd") || box.type.equals("uuid");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull Box box) {
        return box.type.equals("trak") || box.type.equals("meta") || box.type.equals("moov") || box.type.equals("mdia");
    }

    @Override
    public Mp4Handler processBox(@NotNull Box box, @Nullable byte[] payload, Mp4Context context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (box.type.equals("mvhd")) {
                this.processMovieHeader(reader, box);
            } else if (box.type.equals("ftyp")) {
                this.processFileType(reader, box);
            } else {
                if (box.type.equals("hdlr")) {
                    HandlerBox handlerBox = new HandlerBox(reader, box);
                    return this.handlerFactory.getHandler(handlerBox, this.metadata, context);
                }
                if (box.type.equals("mdhd")) {
                    this.processMediaHeader(reader, box, context);
                } else if (box.type.equals("tkhd")) {
                    this.processTrackHeader(reader, box);
                } else if (box.type.equals("uuid")) {
                    Mp4UuidBoxHandler userBoxHandler = new Mp4UuidBoxHandler(this.metadata);
                    userBoxHandler.processBox(box, payload, context);
                }
            }
        } else if (box.type.equals("cmov")) {
            this.directory.addError("Compressed MP4 movies not supported");
        }
        return this;
    }

    private void processFileType(@NotNull SequentialReader reader, @NotNull Box box) throws IOException {
        FileTypeBox fileTypeBox = new FileTypeBox(reader, box);
        fileTypeBox.addMetadata(this.directory);
    }

    private void processMovieHeader(@NotNull SequentialReader reader, @NotNull Box box) throws IOException {
        MovieHeaderBox movieHeaderBox = new MovieHeaderBox(reader, box);
        movieHeaderBox.addMetadata(this.directory);
    }

    private void processMediaHeader(@NotNull SequentialReader reader, @NotNull Box box, Mp4Context context) throws IOException {
        new MediaHeaderBox(reader, box, context);
    }

    private void processTrackHeader(@NotNull SequentialReader reader, @NotNull Box box) throws IOException {
        TrackHeaderBox trackHeaderBox = new TrackHeaderBox(reader, box);
        trackHeaderBox.addMetadata(this.directory);
    }
}

