/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResponseHandler<T>
extends AbstractWriteResponseHandler<T> {
    protected static final Logger logger = LoggerFactory.getLogger(WriteResponseHandler.class);
    protected volatile int responses = this.totalBlockFor();
    private static final AtomicIntegerFieldUpdater<WriteResponseHandler> responsesUpdater = AtomicIntegerFieldUpdater.newUpdater(WriteResponseHandler.class, "responses");

    public WriteResponseHandler(Collection<InetAddress> writeEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Keyspace keyspace, Runnable callback, WriteType writeType) {
        super(keyspace, writeEndpoints, pendingEndpoints, consistencyLevel, callback, writeType);
    }

    public WriteResponseHandler(InetAddress endpoint, WriteType writeType, Runnable callback) {
        this(Arrays.asList(endpoint), Collections.emptyList(), ConsistencyLevel.ONE, null, callback, writeType);
    }

    public WriteResponseHandler(InetAddress endpoint, WriteType writeType) {
        this(endpoint, writeType, null);
    }

    @Override
    public void response(MessageIn<T> m) {
        if (responsesUpdater.decrementAndGet(this) == 0) {
            this.signal();
        }
    }

    @Override
    protected int ackCount() {
        return this.totalBlockFor() - this.responses;
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

