/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class BooleanSerializer
implements TypeSerializer<Boolean> {
    private static final ByteBuffer TRUE = ByteBuffer.wrap(new byte[]{1});
    private static final ByteBuffer FALSE = ByteBuffer.wrap(new byte[]{0});
    public static final BooleanSerializer instance = new BooleanSerializer();

    @Override
    public Boolean deserialize(ByteBuffer bytes) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        byte value = bytes.get(bytes.position());
        return value != 0;
    }

    @Override
    public ByteBuffer serialize(Boolean value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : (value != false ? TRUE : FALSE);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 1 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 1 or 0 byte value (%d)", bytes.remaining()));
        }
    }

    @Override
    public String toString(Boolean value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }
}

