/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.IOException;
import org.caffinitas.ohc.linked.AbstractDataInput;
import org.caffinitas.ohc.linked.HashEntries;

final class HashEntryKeyInput
extends AbstractDataInput {
    HashEntryKeyInput(long hashEntryAdr) {
        super(hashEntryAdr, 56L, HashEntries.getKeyLen(hashEntryAdr));
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (ch1 << 8) + ch2;
    }

    @Override
    public char readChar() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public int readInt() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        int ch3 = this.readUnsignedByte();
        int ch4 = this.readUnsignedByte();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readUnsignedByte() << 56) + ((long)(this.readUnsignedByte() & 0xFF) << 48) + ((long)(this.readUnsignedByte() & 0xFF) << 40) + ((long)(this.readUnsignedByte() & 0xFF) << 32) + ((long)(this.readUnsignedByte() & 0xFF) << 24) + (long)((this.readUnsignedByte() & 0xFF) << 16) + (long)((this.readUnsignedByte() & 0xFF) << 8) + (long)(this.readUnsignedByte() & 0xFF);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }
}

