## ----echo = FALSE, results = "hide"--------------------------------------
knitr::opts_chunk$set(error = FALSE)
human_no <- function(x) {
  s <- log10(floor(x + 1))
  p <- c(0, thousand = 3, million = 6, billion = 9, trillion = 12)
  i <- s > p
  j <- max(which(i))
  str <- names(p)[j]
  if (nzchar(str)) {
    paste(signif(x / 10^p[[j]], 3), str)
  } else {
    as.character(x)
  }
}
set.seed(1)

## ------------------------------------------------------------------------
ids::random_id()

## ------------------------------------------------------------------------
ids::random_id(5)

## ------------------------------------------------------------------------
ids::random_id(5, 8)

## ------------------------------------------------------------------------
f <- ids::random_id(NULL, 8)
f

## ------------------------------------------------------------------------
f()
f(4)

## ------------------------------------------------------------------------
ids::uuid()

## ------------------------------------------------------------------------
ids::uuid(4)

## ------------------------------------------------------------------------
ids::uuid(4, use_time = TRUE)

## ------------------------------------------------------------------------
ids::uuid(5, drop_hyphens = TRUE)

## ------------------------------------------------------------------------
ids::adjective_animal()

## ------------------------------------------------------------------------
ids::adjective_animal(4)

## ------------------------------------------------------------------------
ids::adjective_animal(4, 3)

## ----echo = FALSE, results = "hide"--------------------------------------
n1 <- length(ids:::gfycat_animals)
n2 <- length(ids:::gfycat_adjectives)

## ------------------------------------------------------------------------
ids::adjective_animal(4, max_len = 6)

## ------------------------------------------------------------------------
ids::adjective_animal(20, max_len = c(5, Inf))

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "kebab")

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "dot")

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "camel")

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "pascal")

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "constant")

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "lower")

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "upper")

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "sentence")

## ------------------------------------------------------------------------
ids::adjective_animal(1, 2, style = "title")

## ------------------------------------------------------------------------
aa3 <- ids::adjective_animal(NULL, 3, style = "kebab", max_len = c(6, 8))

## ------------------------------------------------------------------------
aa3()
aa3(4)

## ------------------------------------------------------------------------
ids::sentence()

## ------------------------------------------------------------------------
ids::sentence(2, "dot")

## ------------------------------------------------------------------------
ids::sentence(4, past = TRUE)

## ------------------------------------------------------------------------
ids::proquint(10)

## ------------------------------------------------------------------------
ids::proquint(5, 1)
ids::proquint(2, 4)

## ------------------------------------------------------------------------
ids::proquint_to_int("kapop")
ids::int_to_proquint(25258)

## ------------------------------------------------------------------------
w <- ids::int_to_proquint_word(sample(2^16, 10) - 1L)
w

## ------------------------------------------------------------------------
ids::proquint_word_to_int(w)

## ------------------------------------------------------------------------
ids::int_to_proquint(.Machine$integer.max - 1)
ids::int_to_proquint(2 / .Machine$double.eps)

## ------------------------------------------------------------------------
p <- ids::proquint(1, 6)

## ----error = TRUE--------------------------------------------------------
ids::proquint_to_int(p)

## ----error = TRUE--------------------------------------------------------
ids::proquint_to_int(p, as = "numeric")

## ------------------------------------------------------------------------
ids::proquint_to_int(p, as = "bignum")

## ------------------------------------------------------------------------
pokemon <- tolower(rcorpora::corpora("games/pokemon")$pokemon$name)
length(pokemon)

## ------------------------------------------------------------------------
adjectives <- tolower(rcorpora::corpora("words/adjs")$adjs)
length(adjectives)

## ------------------------------------------------------------------------
ids::ids(1, adjectives, pokemon)

## ------------------------------------------------------------------------
ids::ids(10, adjectives, pokemon, style = "dot")

## ------------------------------------------------------------------------
adjective_pokemon <- function(n = 1, style = "snake") {
  pokemon <- tolower(rcorpora::corpora("games/pokemon")$pokemon$name)
  adjectives <- tolower(rcorpora::corpora("words/adjs")$adjs)
  ids::ids(n, adjectives, pokemon, style = style)
}

adjective_pokemon(10, "kebab")

## ------------------------------------------------------------------------
moods <- tolower(rcorpora::corpora("humans/moods")$moods)
scientists <- tolower(rcorpora::corpora("humans/scientists")$scientists)

## ------------------------------------------------------------------------
sample(moods, 10)

## ------------------------------------------------------------------------
sample(scientists, 10)

## ------------------------------------------------------------------------
scientists <- vapply(strsplit(sub("(-|jr\\.$)", "", scientists), " "),
                     tail, character(1), 1)

## ------------------------------------------------------------------------
sample(scientists, 10)

## ------------------------------------------------------------------------
ids::ids(1, moods, scientists)

## ------------------------------------------------------------------------
sci_id <- ids::ids(NULL, moods, scientists, style = "kebab")

## ------------------------------------------------------------------------
sci_id(10)

