/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.visitors;

import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.visitors.NodeVisitor;

public class TagFindingVisitor
extends NodeVisitor {
    private String[] tagsToBeFound;
    private int[] count;
    private int[] endTagCount;
    private NodeList[] tags;
    private NodeList[] endTags;
    private boolean endTagCheck;

    public TagFindingVisitor(String[] tagsToBeFound) {
        this(tagsToBeFound, false);
    }

    public TagFindingVisitor(String[] tagsToBeFound, boolean endTagCheck) {
        this.tagsToBeFound = tagsToBeFound;
        this.tags = new NodeList[tagsToBeFound.length];
        if (endTagCheck) {
            this.endTags = new NodeList[tagsToBeFound.length];
            this.endTagCount = new int[tagsToBeFound.length];
        }
        for (int i = 0; i < tagsToBeFound.length; ++i) {
            this.tags[i] = new NodeList();
            if (!endTagCheck) continue;
            this.endTags[i] = new NodeList();
        }
        this.count = new int[tagsToBeFound.length];
        this.endTagCheck = endTagCheck;
    }

    public int getTagCount(int index) {
        return this.count[index];
    }

    @Override
    public void visitTag(Tag tag) {
        for (int i = 0; i < this.tagsToBeFound.length; ++i) {
            if (!tag.getTagName().equalsIgnoreCase(this.tagsToBeFound[i])) continue;
            int n = i;
            this.count[n] = this.count[n] + 1;
            this.tags[i].add(tag);
        }
    }

    @Override
    public void visitEndTag(Tag tag) {
        if (!this.endTagCheck) {
            return;
        }
        for (int i = 0; i < this.tagsToBeFound.length; ++i) {
            if (!tag.getTagName().equalsIgnoreCase(this.tagsToBeFound[i])) continue;
            int n = i;
            this.endTagCount[n] = this.endTagCount[n] + 1;
            this.endTags[i].add(tag);
        }
    }

    public Node[] getTags(int index) {
        return this.tags[index].toNodeArray();
    }

    public int getEndTagCount(int index) {
        return this.endTagCount[index];
    }
}

