package ZoneMinder::Base;

use 5.006;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

use constant ZM_VERSION => '1.36.35';

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration  use ZoneMinder ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(ZM_VERSION) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw();

our $VERSION = '1.36.35';

1;
__END__

=head1 NAME

ZoneMinder::Base - Base perl module for ZoneMinder

=head1 SYNOPSIS

use ZoneMinder::Base;

=head1 DESCRIPTION

This module is the base module for the rest of the ZoneMinder modules. It
is included by each of the other modules but serves no purpose other than
to propagate the perl module version amongst the other modules. You will
never need to use this module directly but if you write new ZoneMinder
modules they should include it.

=head2 EXPORT

None by default.

=head1 SEE ALSO

http://www.zoneminder.com

=head1 AUTHOR

Philip Coombes, E<lt>philip.coombes@zoneminder.comE<gt>

=head1 COPYRIGHT AND LICENSE

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

=cut
