/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    public void dragFinished(DragSourceEvent event) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent event) {
        event.image = this.getDragSourceImage(event);
    }

    Image getDragSourceImage(DragSourceEvent event) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Table table = (Table)this.control;
        TableItem[] selection = table.getSelection();
        if (selection.length == 0) {
            return null;
        }
        int tableImageList = OS.SendMessage(table.handle, 4098, 1, 0);
        if (tableImageList != 0) {
            int count = Math.min(selection.length, 10);
            Rectangle bounds = selection[0].getBounds(0);
            int i = 1;
            while (i < count) {
                bounds = bounds.union(selection[i].getBounds(0));
                ++i;
            }
            int hDC = OS.GetDC(0);
            int hDC1 = OS.CreateCompatibleDC(hDC);
            int bitmap = OS.CreateCompatibleBitmap(hDC, bounds.width, bounds.height);
            int hOldBitmap = OS.SelectObject(hDC1, bitmap);
            RECT rect = new RECT();
            rect.right = bounds.width;
            rect.bottom = bounds.height;
            int hBrush = OS.GetStockObject(0);
            OS.FillRect(hDC1, rect, hBrush);
            int i2 = 0;
            while (i2 < count) {
                TableItem selected = selection[i2];
                Rectangle cell = selected.getBounds(0);
                POINT pt = new POINT();
                int imageList = OS.SendMessage(table.handle, 4129, table.indexOf(selected), pt);
                OS.ImageList_Draw(imageList, 0, hDC1, cell.x - bounds.x, cell.y - bounds.y, 4);
                OS.ImageList_Destroy(imageList);
                ++i2;
            }
            OS.SelectObject(hDC1, hOldBitmap);
            OS.DeleteDC(hDC1);
            OS.ReleaseDC(0, hDC);
            Display display = table.getDisplay();
            this.dragSourceImage = Image.win32_new(display, 0, bitmap);
            return this.dragSourceImage;
        }
        return null;
    }
}

