/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellImportExportInfo;

public class CellImportExportInfoSaver {
    private HashMap<String, CellImportExportInfo> map = new HashMap();
    private ArrayList<String> cmdList = new ArrayList();
    private static CellImportExportInfoSaver instance = null;

    public static CellImportExportInfoSaver getInstance() {
        if (instance == null) {
            instance = new CellImportExportInfoSaver();
        }
        return instance;
    }

    public static void setInstance(CellImportExportInfoSaver newInstance) {
        instance = newInstance == null ? new CellImportExportInfoSaver() : newInstance;
    }

    public synchronized void save(String tableColumnName, String fileName, String command) {
        this.map.remove(tableColumnName);
        CellImportExportInfo infoObject = new CellImportExportInfo(tableColumnName, fileName, command);
        this.map.put(tableColumnName, infoObject);
        if (command != null && command.length() > 0) {
            this.cmdList.add(command);
            Collections.sort(this.cmdList);
        }
    }

    public CellImportExportInfo get(String tableColumnName) {
        return this.map.get(tableColumnName);
    }

    public synchronized String[] getCmdList() {
        String[] data = new String[this.cmdList.size()];
        return this.cmdList.toArray(data);
    }

    public static void remove(String tableColumnName) {
        if (instance == null) {
            instance = new CellImportExportInfoSaver();
        }
        CellImportExportInfoSaver.instance.map.remove(tableColumnName);
    }

    public void add(CellImportExportInfo info) {
        this.map.put(info.getTableColumnName(), info);
    }

    public synchronized void setData(CellImportExportInfo[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.map.put(data[i].getTableColumnName(), data[i]);
        }
    }

    public synchronized void setCmdList(String[] data) {
        this.cmdList = new ArrayList<String>(Arrays.asList(data));
        Collections.sort(this.cmdList);
    }

    public synchronized CellImportExportInfo[] getData() {
        if (instance == null) {
            instance = new CellImportExportInfoSaver();
        }
        CellImportExportInfo[] array = new CellImportExportInfo[CellImportExportInfoSaver.instance.map.size()];
        Iterator<CellImportExportInfo> iterator = CellImportExportInfoSaver.instance.map.values().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            array[index] = iterator.next();
            ++index;
        }
        return array;
    }
}

