/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumnFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Interval;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.NoIx;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;

public class ScaleFactory {
    public static final int DEFAULT_CALL_DEPTH = 4;
    private IndexedColumn _indexedColumn;
    private int _callDepth;

    public ScaleFactory(List<Object[]> rows, int colIx, ColumnDisplayDefinition colDef, int callDepth) {
        this._indexedColumn = IndexedColumnFactory.create(rows, colIx, colDef);
        this._callDepth = callDepth;
    }

    public DataScale createScale(DataScaleListener dataScaleListener) {
        Object min = this._indexedColumn.getMin();
        Object max = this._indexedColumn.getMax();
        DataScale ret = new DataScale(this._indexedColumn.getColumnName(), dataScaleListener, this._indexedColumn.getColumnIndex(), this._indexedColumn.getColumnDisplayDefinition());
        if (0 == this._indexedColumn.compareObjects(min, max)) {
            ret.addInterval(new Interval(this._indexedColumn, 0, this._indexedColumn.size() - 1, min, max));
            return ret;
        }
        Object[] borders = this.createBorders(min, max).toArray(new Object[0]);
        this.sortBorders(borders);
        Integer lastIx = null;
        Object lastBorder = min;
        for (Object border : borders) {
            int bsRet = this._indexedColumn.binarySearch(border);
            int ip = 0 > bsRet ? -bsRet - 1 : this._indexedColumn.getLastIndexOfVal(bsRet) + 1;
            if (null == lastIx) {
                int firstIx = 0;
                int endIx = Math.max(0, ip - 1);
                if (1 == this.createBorders(this._indexedColumn.get(firstIx), this._indexedColumn.get(endIx)).size()) {
                    int lastIndexOfVal = this._indexedColumn.getLastIndexOfVal(firstIx);
                    ret.addInterval(new Interval(this._indexedColumn, firstIx, lastIndexOfVal, this._indexedColumn.get(firstIx), this._indexedColumn.get(firstIx)));
                    if (lastIndexOfVal + 1 <= endIx) {
                        ret.addInterval(new Interval(this._indexedColumn, lastIndexOfVal + 1, endIx, this._indexedColumn.get(endIx), this._indexedColumn.get(endIx)));
                    }
                } else {
                    ret.addInterval(new Interval(this._indexedColumn, 0, Math.max(0, ip - 1), lastBorder, border));
                }
                lastIx = ip;
            } else if (ip > lastIx) {
                ret.addInterval(new Interval(this._indexedColumn, lastIx, Math.max(0, ip - 1), lastBorder, border));
                lastIx = ip;
            }
            lastBorder = border;
        }
        if (this._indexedColumn.size() > lastIx) {
            ret.addInterval(new Interval(this._indexedColumn, lastIx, this._indexedColumn.size() - 1, lastBorder, max));
        }
        return ret;
    }

    private void sortBorders(Object[] borders) {
        int i;
        NoIx[] noIxes = new NoIx[borders.length];
        for (i = 0; i < noIxes.length; ++i) {
            noIxes[i] = new NoIx(borders[i]);
        }
        Arrays.sort(noIxes, this._indexedColumn.getComparator());
        for (i = 0; i < noIxes.length; ++i) {
            borders[i] = noIxes[i].get();
        }
    }

    private HashSet<Object> createBorders(Object min, Object max) {
        HashSet<Object> ret = new HashSet<Object>();
        int[] callDepth = new int[]{0};
        this.divide(min, max, ret, callDepth);
        ret.add(max);
        return ret;
    }

    private void divide(Object min, Object max, HashSet<Object> ret, int[] callDepth) {
        callDepth[0] = callDepth[0] + 1;
        if (this._callDepth == callDepth[0]) {
            return;
        }
        Object mid = this._indexedColumn.getCalculator().getMid(min, max);
        if (0 != this._indexedColumn.compareObjects(min, mid)) {
            ret.add(mid);
        }
        this.divide(min, mid, ret, new int[]{callDepth[0]});
        this.divide(mid, max, ret, new int[]{callDepth[0]});
        callDepth[0] = callDepth[0] - 1;
    }
}

