/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

final class ParameterNode
extends TemplateNode
implements Comparable {
    final QName name;
    final Expr select;
    final int type;

    final TemplateNode clone(Stylesheet stylesheet) {
        ParameterNode ret = new ParameterNode(this.name, this.select.clone(stylesheet), this.type);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    final void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        stylesheet.bindings.push(this.type);
        Object value = this.getValue(stylesheet, mode, context, pos, len);
        if (value != null) {
            stylesheet.bindings.set(this.name, value, this.type);
            if (stylesheet.debug) {
                System.err.println(this + ": set to " + value);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
        stylesheet.bindings.pop(this.type);
    }

    final Object getValue(Stylesheet stylesheet, QName mode, Node context, int pos, int len) throws TransformerException {
        if (this.select != null) {
            return this.select.evaluate(context, pos, len);
        }
        if (this.children != null) {
            Document doc = context instanceof Document ? (Document)context : context.getOwnerDocument();
            DocumentFragment fragment = doc.createDocumentFragment();
            this.children.apply(stylesheet, mode, context, pos, len, fragment, null);
            return Collections.singleton(fragment);
        }
        return null;
    }

    public final boolean references(QName var) {
        if (this.select != null && this.select.references(var)) {
            return true;
        }
        return super.references(var);
    }

    public final int compareTo(Object other) {
        if (other instanceof ParameterNode) {
            ParameterNode pn = (ParameterNode)other;
            boolean r1 = this.references(pn.name);
            boolean r2 = pn.references(this.name);
            if (r1 && r2) {
                throw new IllegalArgumentException("circular definitions");
            }
            if (r1) {
                return 1;
            }
            if (r2) {
                return -1;
            }
        }
        return 0;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('[');
        buf.append("name=");
        buf.append(this.name);
        if (this.select != null) {
            buf.append(",select=");
            buf.append(this.select);
        }
        buf.append(",type=");
        switch (this.type) {
            case 0: {
                buf.append("variable");
                break;
            }
            case 1: {
                buf.append("param");
                break;
            }
            case 2: {
                buf.append("with-param");
                break;
            }
        }
        buf.append(']');
        return buf.toString();
    }

    ParameterNode(QName name, Expr select, int type) {
        this.name = name;
        this.select = select;
        this.type = type;
    }
}

