/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.sablecc.sablecc.LR0Item;
import org.sablecc.sablecc.Production;

final class LR0ItemSet
implements Cloneable,
Comparable {
    private final TreeMap items;
    private int hashCode;
    LR0Item[] items_;
    boolean modified_ = true;

    LR0ItemSet() {
        this.items = new TreeMap();
    }

    private LR0ItemSet(LR0ItemSet set) {
        this.items = (TreeMap)set.items.clone();
    }

    void set(LR0Item item) {
        if (this.items.put(item, item) == null) {
            this.hashCode += item.hashCode();
            this.modified_ = true;
        }
    }

    boolean get(LR0Item item) {
        return this.items.get(item) != null;
    }

    private void computeArray() {
        Vector itemVector = new Vector(0);
        Iterator e = this.items.keySet().iterator();
        while (e.hasNext()) {
            itemVector.addElement(e.next());
        }
        this.items_ = new LR0Item[itemVector.size()];
        itemVector.copyInto(this.items_);
        this.modified_ = false;
    }

    LR0Item[] items() {
        if (this.modified_) {
            this.computeArray();
        }
        return this.items_;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Production[] productions = Production.productions();
        boolean space = false;
        for (int i = 0; i < productions.length; ++i) {
            int rightsideLength = productions[i].rightside().length;
            for (int j = 0; j <= rightsideLength; ++j) {
                LR0Item item = new LR0Item(productions[i].index, j);
                if (!this.get(item)) continue;
                if (space) {
                    result.append(",");
                } else {
                    space = true;
                }
                result.append(item);
            }
        }
        result.append("}");
        return result.toString();
    }

    public Object clone() {
        return new LR0ItemSet(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LR0ItemSet set = (LR0ItemSet)obj;
        if (set.items.size() != this.items.size()) {
            return false;
        }
        Iterator e = this.items.keySet().iterator();
        while (e.hasNext()) {
            if (set.get((LR0Item)e.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int compareTo(Object object) {
        LR0ItemSet set = (LR0ItemSet)object;
        int result = this.items.size() - set.items.size();
        if (result == 0) {
            Iterator e = this.items.keySet().iterator();
            Iterator f = set.items.keySet().iterator();
            while (e.hasNext() && f.hasNext() && result == 0) {
                result = ((LR0Item)e.next()).compareTo(f.next());
            }
            if (result == 0) {
                if (e.hasNext()) {
                    return 1;
                }
                if (f.hasNext()) {
                    return -1;
                }
            }
        }
        return result;
    }
}

