/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Map;
import org.sablecc.sablecc.IntegerCast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.ResolveProdTransformIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AAst;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AListTerm;
import org.sablecc.sablecc.node.ANewListTerm;
import org.sablecc.sablecc.node.ANewTerm;
import org.sablecc.sablecc.node.ANullTerm;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.AProdName;
import org.sablecc.sablecc.node.ASimpleListTerm;
import org.sablecc.sablecc.node.ASimpleTerm;
import org.sablecc.sablecc.node.PAlt;
import org.sablecc.sablecc.node.TId;

public class ComputeCGNomenclature
extends DepthFirstAdapter {
    private String currentProd;
    private String currentAlt;
    private int counter;
    private ResolveIds ids;
    private ResolveProdTransformIds prodTransformIds;
    private Map altElemTypes;
    private final Map altTransformElemTypes = new TypedHashMap(NodeCast.instance, StringCast.instance);
    private final Map termNumbers = new TypedHashMap(NodeCast.instance, IntegerCast.instance);

    public ComputeCGNomenclature(ResolveIds ids, ResolveProdTransformIds prodTransformIds) {
        this.ids = ids;
        this.prodTransformIds = prodTransformIds;
    }

    public void setAltElemTypes(Map aMap) {
        this.altElemTypes = aMap;
    }

    public Map getAltTransformElemTypes() {
        return this.altTransformElemTypes;
    }

    public Map getTermNumbers() {
        return this.termNumbers;
    }

    @Override
    public void caseAProd(AProd production) {
        this.currentProd = "P" + ResolveIds.name(production.getId().getText());
        Object[] temp = production.getAlts().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PAlt)temp[i]).apply(this);
        }
    }

    @Override
    public void inAAlt(AAlt nodeAlt) {
        this.counter = 0;
        this.currentAlt = nodeAlt.getAltName() != null ? "A" + ResolveIds.name(nodeAlt.getAltName().getText()) + this.currentProd.substring(1) : "A" + this.currentProd.substring(1);
        this.counter = 0;
    }

    @Override
    public void caseAAst(AAst node) {
    }

    @Override
    public void inAElem(AElem node) {
        String elemType = (String)this.ids.elemTypes.get(node);
        if (node.getElemName() != null) {
            this.ids.altsElemNameTypes.put(this.currentAlt + "." + node.getElemName().getText(), elemType);
        }
    }

    @Override
    public void inANewTerm(ANewTerm node) {
        AProdName aProdName = (AProdName)node.getProdName();
        String type = "P" + ResolveIds.name(aProdName.getId().getText());
        this.altTransformElemTypes.put(node, type);
        this.termNumbers.put(node, new Integer(++this.counter));
    }

    @Override
    public void inANewListTerm(ANewListTerm node) {
        AProdName aProdName = (AProdName)node.getProdName();
        String type = "P" + ResolveIds.name(aProdName.getId().getText());
        this.altTransformElemTypes.put(node, type);
        this.termNumbers.put(node, new Integer(++this.counter));
    }

    @Override
    public void outAListTerm(AListTerm node) {
        if (node.getListTerms().size() > 0) {
            Object[] temp = node.getListTerms().toArray();
            String firstTermType = (String)this.altTransformElemTypes.get(temp[0]);
            if (firstTermType != null) {
                if (!firstTermType.startsWith("L")) {
                    this.altTransformElemTypes.put(node, "L" + firstTermType);
                } else {
                    this.altTransformElemTypes.put(node, firstTermType);
                }
            }
        } else {
            this.altTransformElemTypes.put(node, "Lnull");
        }
        this.termNumbers.put(node, new Integer(++this.counter));
    }

    @Override
    public void caseASimpleTerm(ASimpleTerm node) {
        String name;
        String elemType = (String)this.altElemTypes.get(this.currentAlt + "." + node.getId().getText());
        if (node.getSimpleTermTail() == null) {
            name = elemType;
            if (name.startsWith("P")) {
                node.setSimpleTermTail((TId)node.getId().clone());
            }
        } else {
            String termTail = node.getSimpleTermTail().getText();
            name = (String)this.prodTransformIds.prodTransformElemTypesString.get(elemType + "." + termTail);
        }
        if (name.endsWith("?")) {
            name = name.substring(0, name.length() - 1);
        }
        this.altTransformElemTypes.put(node, name);
        this.termNumbers.put(node, new Integer(++this.counter));
    }

    @Override
    public void caseANullTerm(ANullTerm node) {
        this.altTransformElemTypes.put(node, "null");
        this.termNumbers.put(node, new Integer(++this.counter));
    }

    @Override
    public void caseASimpleListTerm(ASimpleListTerm node) {
        String name;
        String elemType = (String)this.altElemTypes.get(this.currentAlt + "." + node.getId().getText());
        if (node.getSimpleTermTail() == null) {
            name = elemType;
            if (name.startsWith("P")) {
                node.setSimpleTermTail((TId)node.getId().clone());
            }
        } else {
            String termTail = node.getSimpleTermTail().getText();
            name = (String)this.prodTransformIds.prodTransformElemTypesString.get(elemType + "." + termTail);
        }
        if (name.endsWith("?")) {
            name = name.substring(0, name.length() - 1);
        }
        this.altTransformElemTypes.put(node, name);
        this.termNumbers.put(node, new Integer(++this.counter));
    }
}

