/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileCreateEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myParent;
    private final boolean myDirectory;
    @NotNull
    private final String myChildName;
    private VirtualFile myCreatedFile;

    public VFileCreateEvent(Object requestor, @NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, boolean isFromRefresh) {
        if (parent == null) {
            VFileCreateEvent.$$$reportNull$$$0(0);
        }
        if (childName == null) {
            VFileCreateEvent.$$$reportNull$$$0(1);
        }
        super(requestor, isFromRefresh);
        this.myChildName = childName;
        this.myParent = parent;
        this.myDirectory = isDirectory;
    }

    @NotNull
    public String getChildName() {
        String string = this.myChildName;
        if (string == null) {
            VFileCreateEvent.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile2 = this.myParent;
        if (virtualFile2 == null) {
            VFileCreateEvent.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[create " + (this.myDirectory ? "dir " : "file ") + this.myChildName + " in " + this.myParent.getUrl() + "]";
    }

    @Override
    @NotNull
    protected String computePath() {
        String parentPath = this.myParent.getPath();
        String string = StringUtil.endsWithChar((CharSequence)parentPath, (char)'/') ? parentPath + this.myChildName : parentPath + "/" + this.myChildName;
        if (string == null) {
            VFileCreateEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public VirtualFile getFile() {
        if (this.myCreatedFile != null) {
            return this.myCreatedFile;
        }
        this.myCreatedFile = this.myParent.findChild(this.myChildName);
        return this.myCreatedFile;
    }

    public void resetCache() {
        this.myCreatedFile = null;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
        if (virtualFileSystem == null) {
            VFileCreateEvent.$$$reportNull$$$0(5);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        if (this.myParent.isValid()) {
            boolean childExists = this.myParent.findChild(this.myChildName) != null;
            return !childExists;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        if (this.myDirectory != event.myDirectory) {
            return false;
        }
        if (!this.myChildName.equals(event.myChildName)) {
            return false;
        }
        return this.myParent.equals(event.myParent);
    }

    @Override
    public int hashCode() {
        int result2 = this.myParent.hashCode();
        result2 = 31 * result2 + (this.myDirectory ? 1 : 0);
        result2 = 31 * result2 + this.myChildName.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

