/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Shape;

public class DiagramColorManagerBase
extends DiagramColorManager {
    public static final Color REALIZATION = new JBColor(new Color(0, 130, 0), new Color(96, 147, 80));
    public static final Color GENERALIZATION = new JBColor(new Color(0, 0, 130), (Color)JBColor.blue);
    public static final Color DEFAULT_EDGE_COLOR = new JBColor(Color.GRAY.darker(), JBColor.foreground());
    public static final Color ANNOTATION = new Color(153, 153, 0);
    public static final Color INNER = new JBColor(new Color(130, 0, 0), (Color)JBColor.red);

    @Override
    public Color getNodeForegroundColor(boolean selected) {
        return UIUtil.getListForeground((boolean)selected);
    }

    @Override
    public Color getEdgeColor(DiagramEdge edge) {
        if (edge == null) {
            return DEFAULT_EDGE_COLOR;
        }
        DiagramRelationshipInfo relationship = edge.getRelationship();
        if (relationship.getStartArrow() == DiagramRelationshipInfo.DELTA) {
            if (relationship.getLineType() == DiagramLineType.SOLID) {
                return GENERALIZATION;
            }
            if (relationship.getLineType() == DiagramLineType.DASHED) {
                return REALIZATION;
            }
        }
        if (!DiagramColorManagerBase.isArrow(relationship.getEndArrow()) && !DiagramColorManagerBase.isArrow(relationship.getStartArrow()) && relationship.getLineType() == DiagramLineType.DOTTED) {
            return ANNOTATION;
        }
        return DEFAULT_EDGE_COLOR;
    }

    private static boolean isArrow(Shape arrow) {
        return arrow != null && arrow != DiagramRelationshipInfo.NONE;
    }
}

