/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.desktop.gnome;

import com.github.markusbernhardt.proxy.ProxySearchStrategy;
import com.github.markusbernhardt.proxy.selector.direct.NoProxySelector;
import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import com.github.markusbernhardt.proxy.selector.whitelist.ProxyBypassListSelector;
import com.github.markusbernhardt.proxy.util.EmptyXMLResolver;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import com.github.markusbernhardt.proxy.util.ProxyException;
import com.github.markusbernhardt.proxy.util.ProxyUtil;
import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GnomeProxySearchStrategy
implements ProxySearchStrategy {
    @Override
    public ProxySelector getProxySelector() throws ProxyException {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Detecting Gnome proxy settings", new Object[0]);
        Properties settings = this.readSettings();
        String type = settings.getProperty("/system/proxy/mode");
        ProxySelector result = null;
        if (type == null) {
            String useProxy = settings.getProperty("/system/http_proxy/use_http_proxy");
            if (useProxy == null) {
                return null;
            }
            String string = type = Boolean.parseBoolean(useProxy) ? "manual" : "none";
        }
        if ("none".equals(type)) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome uses no proxy", new Object[0]);
            result = NoProxySelector.getInstance();
        }
        if ("manual".equals(type)) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome uses manual proxy settings", new Object[0]);
            result = this.setupFixedProxySelector(settings);
        }
        if ("auto".equals(type)) {
            String pacScriptUrl = settings.getProperty("/system/proxy/autoconfig_url", "");
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome uses autodetect script {0}", pacScriptUrl);
            result = ProxyUtil.buildPacSelectorForUrl(pacScriptUrl);
        }
        String noProxyList = settings.getProperty("/system/http_proxy/ignore_hosts", null);
        if (result != null && noProxyList != null && noProxyList.trim().length() > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome uses proxy bypass list: {0}", noProxyList);
            result = new ProxyBypassListSelector(noProxyList, result);
        }
        return result;
    }

    @Override
    public String getName() {
        return "gnome";
    }

    public Properties readSettings() throws ProxyException {
        Properties settings = new Properties();
        try {
            this.parseSettings("/system/proxy/", settings);
            this.parseSettings("/system/http_proxy/", settings);
        }
        catch (IOException e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Gnome settings file error.", e);
            throw new ProxyException(e);
        }
        return settings;
    }

    private File findSettingsFile(String context) {
        String[] parts;
        File userDir = new File(PlatformUtil.getUserHomeDir());
        StringBuilder path = new StringBuilder();
        for (String part : parts = context.split("/")) {
            path.append(part);
            path.append(File.separator);
        }
        File settingsFile = new File(userDir, ".gconf" + File.separator + path.toString() + "%gconf.xml");
        if (!settingsFile.exists()) {
            Logger.log(this.getClass(), Logger.LogLevel.WARNING, "Gnome settings: {0} not found.", settingsFile);
            return null;
        }
        return settingsFile;
    }

    private ProxySelector setupFixedProxySelector(Properties settings) {
        if (!this.hasProxySettings(settings)) {
            return null;
        }
        ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
        this.installHttpSelector(settings, ps);
        if (this.useForAllProtocols(settings)) {
            ps.setFallbackSelector(ps.getSelector("http"));
        } else {
            this.installSecureSelector(settings, ps);
            this.installFtpSelector(settings, ps);
            this.installSocksSelector(settings, ps);
        }
        return ps;
    }

    private boolean useForAllProtocols(Properties settings) {
        return Boolean.parseBoolean(settings.getProperty("/system/http_proxy/use_same_proxy", "false"));
    }

    private boolean hasProxySettings(Properties settings) {
        String proxyHost = settings.getProperty("/system/http_proxy/host", null);
        return proxyHost != null && proxyHost.length() > 0;
    }

    private void installHttpSelector(Properties settings, ProtocolDispatchSelector ps) throws NumberFormatException {
        String proxyHost = settings.getProperty("/system/http_proxy/host", null);
        int proxyPort = Integer.parseInt(settings.getProperty("/system/http_proxy/port", "0").trim());
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome http proxy is {0}:{1}", proxyHost, proxyPort);
            ps.setSelector("http", new FixedProxySelector(proxyHost.trim(), proxyPort));
        }
    }

    private void installSocksSelector(Properties settings, ProtocolDispatchSelector ps) throws NumberFormatException {
        String proxyHost = settings.getProperty("/system/proxy/socks_host", null);
        int proxyPort = Integer.parseInt(settings.getProperty("/system/proxy/socks_port", "0").trim());
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome socks proxy is {0}:{1}", proxyHost, proxyPort);
            ps.setSelector("socks", new FixedProxySelector(proxyHost.trim(), proxyPort));
        }
    }

    private void installFtpSelector(Properties settings, ProtocolDispatchSelector ps) throws NumberFormatException {
        String proxyHost = settings.getProperty("/system/proxy/ftp_host", null);
        int proxyPort = Integer.parseInt(settings.getProperty("/system/proxy/ftp_port", "0").trim());
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome ftp proxy is {0}:{1}", proxyHost, proxyPort);
            ps.setSelector("ftp", new FixedProxySelector(proxyHost.trim(), proxyPort));
        }
    }

    private void installSecureSelector(Properties settings, ProtocolDispatchSelector ps) throws NumberFormatException {
        String proxyHost = settings.getProperty("/system/proxy/secure_host", null);
        int proxyPort = Integer.parseInt(settings.getProperty("/system/proxy/secure_port", "0").trim());
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome secure proxy is {0}:{1}", proxyHost, proxyPort);
            ps.setSelector("https", new FixedProxySelector(proxyHost.trim(), proxyPort));
            ps.setSelector("sftp", new FixedProxySelector(proxyHost.trim(), proxyPort));
        }
    }

    private Properties parseSettings(String context, Properties settings) throws IOException {
        File settingsFile = this.findSettingsFile(context);
        if (settingsFile == null) {
            return settings;
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            documentBuilder.setEntityResolver(new EmptyXMLResolver());
            Document doc = documentBuilder.parse(settingsFile);
            Element root = doc.getDocumentElement();
            for (Node entry = root.getFirstChild(); entry != null; entry = entry.getNextSibling()) {
                if (!"entry".equals(entry.getNodeName()) || !(entry instanceof Element)) continue;
                String entryName = ((Element)entry).getAttribute("name");
                settings.setProperty(context + entryName, this.getEntryValue((Element)entry));
            }
        }
        catch (SAXException e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Gnome settings parse error", e);
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Gnome settings parse error", e);
            throw new IOException(e.getMessage());
        }
        return settings;
    }

    private String getEntryValue(Element entry) {
        NodeList list;
        String type = entry.getAttribute("type");
        if ("int".equals(type) || "bool".equals(type)) {
            return entry.getAttribute("value");
        }
        if ("string".equals(type) && (list = entry.getElementsByTagName("stringvalue")).getLength() > 0) {
            return list.item(0).getTextContent();
        }
        if ("list".equals(type)) {
            StringBuilder result = new StringBuilder();
            NodeList list2 = entry.getElementsByTagName("li");
            for (int i = 0; i < list2.getLength(); ++i) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(this.getEntryValue((Element)list2.item(i)));
            }
            return result.toString();
        }
        return null;
    }
}

