/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.JdbcTemplateParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StatelessTextDecompositionBuilder
implements JdbcTemplateParser.EventProcessor {
    private final Builder myBuilder;
    private String myError;
    private final TextDecomposition.PatternFactory myPatternFactory;
    private final List<String> myPropSeparators;

    public static StatelessTextDecomposition.Node build(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns2) throws StatelessTextDecomposition.InvalidTemplateException {
        if (template == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(0);
        }
        if (patterns2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(1);
        }
        try {
            StatelessTextDecompositionBuilder builder = new StatelessTextDecompositionBuilder(template, patterns2);
            StatelessTextDecomposition.Node node = builder.getNode();
            StatelessTextDecomposition.FollowBuilder.buildFollow(node);
            return node;
        }
        catch (TemplateBuildingException e) {
            throw new StatelessTextDecomposition.InvalidTemplateException(e.getMessage());
        }
        catch (PatternSyntaxException e) {
            throw new StatelessTextDecomposition.InvalidTemplateException(e.getMessage());
        }
    }

    private StatelessTextDecompositionBuilder(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns2) {
        if (template == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(2);
        }
        if (patterns2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(3);
        }
        this.myBuilder = new Builder();
        this.myPropSeparators = ContainerUtil.newArrayList();
        this.myPatternFactory = patterns2;
        this.myBuilder.enter();
        if (!JdbcTemplateParser.parse(template, this)) {
            throw new TemplateBuildingException(this.myError);
        }
        this.myBuilder.leave();
    }

    @Override
    public void processString(@NotNull String s) {
        if (s == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(4);
        }
        this.myBuilder.push(new StatelessTextDecomposition.TextNode(s));
    }

    @Override
    public void processGroupStart() {
        this.myBuilder.enter();
    }

    @Override
    public void processGroupFinish() {
        this.myBuilder.leave();
    }

    @Override
    public void processOptionality() {
        this.myBuilder.optionalize();
    }

    @Override
    public void processNegation() {
        this.myBuilder.negate();
    }

    @Override
    public void processParameter(@Nullable String name, @Nullable String type, @Nullable String defValue, @Nullable String configuration) {
        String patternOverride;
        assert (type != null || name != null);
        int patIdx = type == null ? -1 : type.indexOf("/");
        String string = patternOverride = patIdx == -1 ? null : type.substring(patIdx + 1);
        if (patIdx != -1) {
            type = type.substring(0, patIdx);
        }
        this.pushParameter(name, (String)ObjectUtils.chooseNotNull((Object)type, (Object)name), patternOverride, defValue, configuration);
    }

    @Override
    public void processError(@NotNull String error2) {
        if (error2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(5);
        }
        this.myError = error2;
    }

    @Override
    public void processListBranch() {
        this.myBuilder.leave();
        this.myBuilder.enter();
    }

    @Override
    public void processListStart(@NotNull String separator) {
        if (separator == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(6);
        }
        this.myPropSeparators.add(separator);
        this.myBuilder.enter();
        this.myBuilder.enter();
    }

    @Override
    public void processListFinish() {
        this.myBuilder.leave();
        this.myBuilder.leaveList(this.myPropSeparators.remove(this.myPropSeparators.size() - 1));
    }

    @NotNull
    private Pattern getPatternOrThrow(@NotNull String type, @Nullable String configuration, @Nullable String patternOverride) {
        Pattern checkPattern;
        if (type == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(7);
        }
        if ((checkPattern = this.myPatternFactory.getPattern(type, configuration, patternOverride)) == null) {
            throw new TemplateBuildingException("Invalid type name: " + type);
        }
        Pattern pattern = checkPattern;
        if (pattern == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(8);
        }
        return pattern;
    }

    private void pushParameter(@Nullable String name, @NotNull String type, @Nullable String patternOverride, @Nullable String defValue, @Nullable String configuration) {
        if (type == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(9);
        }
        StatelessTextDecomposition.ParameterNode node = new StatelessTextDecomposition.ParameterNode(name, type, defValue, configuration, this.getPatternOrThrow(type, configuration, patternOverride));
        this.myBuilder.push(node);
    }

    @NotNull
    private StatelessTextDecomposition.Node getNode() {
        StatelessTextDecomposition.Node node = this.myBuilder.getResult();
        if (node == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(10);
        }
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternOrThrow";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processListStart";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPatternOrThrow";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "pushParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TemplateBuildingException
    extends RuntimeException {
        public TemplateBuildingException(@NotNull String msg) {
            if (msg == null) {
                TemplateBuildingException.$$$reportNull$$$0(0);
            }
            super(msg);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$TemplateBuildingException", "<init>"));
        }
    }

    private static class Builder {
        private final List<StatelessTextDecomposition.Node> myCurrentNodes = new ArrayList<StatelessTextDecomposition.Node>();
        private final TIntStack myStack = new TIntStack(3);

        private Builder() {
        }

        void push(@NotNull StatelessTextDecomposition.Node node) {
            if (node == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myCurrentNodes.add(node);
        }

        void enter() {
            this.myStack.push(this.myCurrentNodes.size());
        }

        private StatelessTextDecomposition.Node[] extractArray(int mark2) {
            StatelessTextDecomposition.Node[] res2 = new StatelessTextDecomposition.Node[this.myCurrentNodes.size() - mark2];
            for (int i2 = this.myCurrentNodes.size() - 1; i2 >= mark2; --i2) {
                res2[i2 - mark2] = this.myCurrentNodes.get(i2);
                this.myCurrentNodes.remove(i2);
            }
            return res2;
        }

        void leave() {
            int mark2 = this.myStack.pop();
            assert (mark2 <= this.myCurrentNodes.size());
            if (this.myCurrentNodes.size() - mark2 > 1) {
                StatelessTextDecomposition.CompositeNode n = new StatelessTextDecomposition.CompositeNode(this.extractArray(mark2));
                this.myCurrentNodes.add(n);
            }
        }

        void leaveList(@NotNull String sep) {
            if (sep == null) {
                Builder.$$$reportNull$$$0(1);
            }
            int mark2 = this.myStack.pop();
            assert (mark2 <= this.myCurrentNodes.size());
            StatelessTextDecomposition.Node[] nodes2 = this.extractArray(mark2);
            if (nodes2.length == 0) {
                throw new TemplateBuildingException("No choices in list");
            }
            StatelessTextDecomposition.ListChoiceNode[] choices = new StatelessTextDecomposition.ListChoiceNode[nodes2.length];
            for (int i2 = 0; i2 < nodes2.length; ++i2) {
                choices[i2] = new StatelessTextDecomposition.ListChoiceNode(nodes2[i2]);
            }
            StatelessTextDecomposition.ListNode n = new StatelessTextDecomposition.ListNode(new StatelessTextDecomposition.ListChoicesNode(choices), sep);
            this.myCurrentNodes.add(n);
        }

        void optionalize() {
            int size = this.myCurrentNodes.size();
            if (size > 0 && !(this.myCurrentNodes.get(size - 1) instanceof StatelessTextDecomposition.OptionalNode)) {
                StatelessTextDecomposition.Node node = this.myCurrentNodes.get(size - 1);
                this.myCurrentNodes.set(size - 1, new StatelessTextDecomposition.OptionalNode(node));
            }
        }

        void negate() {
            int size = this.myCurrentNodes.size();
            if (size > 0) {
                StatelessTextDecomposition.Node node = this.myCurrentNodes.get(size - 1);
                this.myCurrentNodes.set(size - 1, new StatelessTextDecomposition.AntiNode(node));
            }
        }

        void finish() {
            assert (this.myCurrentNodes.size() <= 1);
            if (this.myCurrentNodes.isEmpty()) {
                this.myCurrentNodes.add(new StatelessTextDecomposition.TextNode(""));
            }
        }

        @NotNull
        StatelessTextDecomposition.Node getResult() {
            this.finish();
            StatelessTextDecomposition.Node node = this.myCurrentNodes.get(0);
            if (node == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sep";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "push";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "leaveList";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

