/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.impl.ui.NotificationsUtil");
    private static final int TITLE_LIMIT = 1000;
    private static final int CONTENT_LIMIT = 10000;

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style) {
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(0);
        }
        String title = notification.getTitle();
        String content = notification.getContent();
        if (title.length() > 1000 || content.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nContent=" + content);
            title = StringUtil.trimLog((String)title, (int)1000);
            content = StringUtil.trimLog((String)content, (int)10000);
        }
        String string = NotificationsUtil.buildHtml(title, null, content, style, "#" + ColorUtil.toHex((Color)NotificationsUtil.getMessageType(notification).getTitleForeground()), null, null);
        if (string == null) {
            NotificationsUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style, boolean isContent, @Nullable Color color, @Nullable String contentStyle) {
        String content;
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(2);
        }
        String title = !isContent ? notification.getTitle() : "";
        String subtitle = !isContent ? notification.getSubtitle() : null;
        String string = content = isContent ? notification.getContent() : "";
        if (title.length() > 1000 || StringUtil.length((CharSequence)subtitle) > 1000 || content.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nSubtitle=" + subtitle + "\nContent=" + content);
            title = StringUtil.trimLog((String)title, (int)1000);
            subtitle = StringUtil.trimLog((String)StringUtil.notNullize((String)subtitle), (int)1000);
            content = StringUtil.trimLog((String)content, (int)10000);
        }
        if (isContent) {
            content = StringUtil.replace((String)content, (String)"<p/>", (String)"<br>");
        }
        String colorText = color == null ? null : "#" + ColorUtil.toHex((Color)color);
        String string2 = NotificationsUtil.buildHtml(title, subtitle, content, style, isContent ? null : colorText, isContent ? colorText : null, contentStyle);
        if (string2 == null) {
            NotificationsUtil.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static String buildHtml(@Nullable String title, @Nullable String subtitle, @Nullable String content, @Nullable String style, @Nullable String titleColor, @Nullable String contentColor, @Nullable String contentStyle) {
        if (StringUtil.isEmpty((String)title) && !StringUtil.isEmpty((String)subtitle)) {
            title = subtitle;
            subtitle = null;
        } else if (!StringUtil.isEmpty((String)title) && !StringUtil.isEmpty((String)subtitle)) {
            title = title + ":";
        }
        StringBuilder result2 = new StringBuilder();
        if (style != null) {
            result2.append("<div style=\"").append(style).append("\">");
        }
        if (!StringUtil.isEmpty((String)title)) {
            result2.append("<b").append(titleColor == null ? ">" : " color=\"" + titleColor + "\">").append(title).append("</b>");
        }
        if (!StringUtil.isEmpty((String)subtitle)) {
            result2.append("&nbsp;").append(titleColor == null ? "" : "<span color=\"" + titleColor + "\">").append(subtitle).append(titleColor == null ? "" : "</span>");
        }
        if (!StringUtil.isEmpty((String)content)) {
            result2.append("<div").append(contentStyle == null ? "" : " style=\"" + contentStyle + "\"").append(contentColor == null ? ">" : " color=\"" + contentColor + "\">").append(content).append("</div>");
        }
        if (style != null) {
            result2.append("</div>");
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)result2.toString());
        if (string == null) {
            NotificationsUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String getFontStyle() {
        String fontName = NotificationsUtil.getFontName();
        return StringUtil.isEmpty((String)fontName) ? null : "font-family:" + fontName + ";";
    }

    @Nullable
    public static Pair<String, Integer> getFontData() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            return Pair.create((Object)uiSettings.getFontFace(), (Object)uiSettings.getFontSize());
        }
        return UIUtil.getSystemFontData();
    }

    @Nullable
    public static String getFontName() {
        Pair<String, Integer> data = NotificationsUtil.getFontData();
        return (String)Pair.getFirst(data);
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification) {
        NotificationListener listener2;
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(5);
        }
        if ((listener2 = notification.getListener()) == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener listener1;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification.getListener()) != null) {
                    listener1.hyperlinkUpdate(notification, e);
                }
            }
        };
    }

    @NotNull
    public static Icon getIcon(@NotNull Notification notification) {
        Icon icon;
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(6);
        }
        if ((icon = notification.getIcon()) != null) {
            Icon icon2 = icon;
            if (icon2 == null) {
                NotificationsUtil.$$$reportNull$$$0(7);
            }
            return icon2;
        }
        switch (notification.getType()) {
            case WARNING: {
                Icon icon3 = AllIcons.General.BalloonWarning;
                if (icon3 == null) {
                    NotificationsUtil.$$$reportNull$$$0(8);
                }
                return icon3;
            }
            case ERROR: {
                Icon icon4 = AllIcons.General.BalloonError;
                if (icon4 == null) {
                    NotificationsUtil.$$$reportNull$$$0(9);
                }
                return icon4;
            }
        }
        Icon icon5 = AllIcons.General.BalloonInformation;
        if (icon5 == null) {
            NotificationsUtil.$$$reportNull$$$0(10);
        }
        return icon5;
    }

    @NotNull
    public static MessageType getMessageType(@NotNull Notification notification) {
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(11);
        }
        switch (notification.getType()) {
            case WARNING: {
                MessageType messageType = MessageType.WARNING;
                if (messageType == null) {
                    NotificationsUtil.$$$reportNull$$$0(12);
                }
                return messageType;
            }
            case ERROR: {
                MessageType messageType = MessageType.ERROR;
                if (messageType == null) {
                    NotificationsUtil.$$$reportNull$$$0(13);
                }
                return messageType;
            }
        }
        MessageType messageType = MessageType.INFO;
        if (messageType == null) {
            NotificationsUtil.$$$reportNull$$$0(14);
        }
        return messageType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/ui/NotificationsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/ui/NotificationsUtil";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtml";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildHtml";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMessageType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

