/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntime;
import com.intellij.docker.view.DockerEnvVarsRuntimeEditor;
import com.intellij.docker.view.DockerPortBindingRuntimeEditor;
import com.intellij.docker.view.DockerPropertiesRuntimeEditor;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.docker.view.DockerTableRuntimeEditor;
import com.intellij.docker.view.DockerTreeFilter;
import com.intellij.docker.view.DockerVolumeBindingsRuntimeEditor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.ui.UIUtil;
import icons.DockerIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerTreeStructure
extends ServersTreeStructure {
    private static final Key<LoggingHandlerBase> ADDITIONAL_LOG_KEY = Key.create((String)"ADDITIONAL_LOG");
    private final Map<Deployment, DeploymentContent> myDeployment2Content;

    public DockerTreeStructure(@NotNull Project project, @NotNull RemoteServersViewContribution contribution, @NotNull ServersTreeNodeSelector nodeSelector) {
        if (project == null) {
            DockerTreeStructure.$$$reportNull$$$0(0);
        }
        if (contribution == null) {
            DockerTreeStructure.$$$reportNull$$$0(1);
        }
        if (nodeSelector == null) {
            DockerTreeStructure.$$$reportNull$$$0(2);
        }
        super(project, contribution, nodeSelector);
        this.myDeployment2Content = new HashMap<Deployment, DeploymentContent>();
    }

    protected AbstractTreeNode createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        return new DockerDeploymentNode(connection, serverNode, deployment);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "contribution";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeSelector";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/view/DockerTreeStructure";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeploymentContent {
        private static final String TOOLBAR_PLACE = "DockerDeploymentContentLogConsole#Toolbar";
        private final Project myProject;
        private final ContentManager myManager;
        private final Deployment myDeployment;
        private final ServersTreeNodeSelector myNodeSelector;
        private boolean myShown;
        private boolean myContentInitialized;
        private JPanel myLogPanel;
        private JComponent myLogToolbar;
        private Content myLogContent;
        private Content myContainerPropsContent;
        private Content myImagePropsContent;
        private Content myEnvVarsContent;
        private Content myPortBindingContent;
        private Content myVolumeBindingContent;

        DeploymentContent(@NotNull Project project, @NotNull Deployment deployment, @NotNull ServersTreeNodeSelector nodeSelector) {
            if (project == null) {
                DeploymentContent.$$$reportNull$$$0(0);
            }
            if (deployment == null) {
                DeploymentContent.$$$reportNull$$$0(1);
            }
            if (nodeSelector == null) {
                DeploymentContent.$$$reportNull$$$0(2);
            }
            this.myShown = false;
            this.myContentInitialized = false;
            this.myProject = project;
            this.myDeployment = deployment;
            this.myNodeSelector = nodeSelector;
            ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
            TabbedPaneContentUI contentUI = new TabbedPaneContentUI(1);
            this.myManager = new ContentManagerImpl((ContentUI)contentUI, true, this.myProject){

                public boolean canCloseAllContents() {
                    return false;
                }
            };
            DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)deployment.getOrCreateLogManager(this.myProject);
            this.myManager.addContentManagerListener((ContentManagerListener)new DockerTabContentListener((DeploymentLogManager)logManager));
            if (logManager.isMainHandlerVisible()) {
                Content content = contentFactory.createContent(logManager.getMainLoggingHandler().getConsole().getComponent(), "Deploy log", true);
                content.setCloseable(false);
                this.myManager.addContent(content);
            }
        }

        public ContentManager getManager() {
            return this.myManager;
        }

        private DockerApplicationRuntime getRuntime() {
            return (DockerApplicationRuntime)this.myDeployment.getRuntime();
        }

        public void show() {
            if (this.myShown) {
                return;
            }
            this.myShown = true;
            this.initContent();
        }

        public void initContent() {
            if (this.myContentInitialized || !this.myShown) {
                return;
            }
            DockerApplicationRuntime applicationRuntime = this.getRuntime();
            if (applicationRuntime == null) {
                return;
            }
            if (applicationRuntime.getContainerId() != null) {
                this.doInitContainerContent();
                this.myContentInitialized = true;
            } else if (applicationRuntime.getImageId() != null) {
                this.doInitImageContent();
                this.myContentInitialized = true;
            }
        }

        private void initLogPanel() {
            this.myLogPanel = new JPanel();
            this.myLogPanel.setLayout(new BorderLayout());
            this.myLogContent = this.myManager.getFactory().createContent((JComponent)this.myLogPanel, "Log", true);
            this.myLogContent.setCloseable(false);
            this.myManager.addContent(this.myLogContent);
            this.myManager.setSelectedContent(this.myLogContent, true);
        }

        private void doInitContainerContent() {
            this.removeOldContent(this.myLogContent);
            this.removeOldContent(this.myEnvVarsContent);
            this.removeOldContent(this.myPortBindingContent);
            this.removeOldContent(this.myVolumeBindingContent);
            this.removeOldContent(this.myContainerPropsContent);
            this.initLogPanel();
            DockerApplicationRuntime applicationRuntime = this.getRuntime();
            applicationRuntime.showLog(this.myProject, EmptyRunnable.getInstance());
            applicationRuntime.inspect((ParameterizedRunnable<DockerAgentContainerConfig>)((ParameterizedRunnable)config -> UIUtil.invokeLaterIfNeeded(() -> {
                this.myContainerPropsContent = new EditorContentCreator((DockerAgentContainerConfig)config, applicationRuntime){
                    final /* synthetic */ DockerAgentContainerConfig val$config;
                    final /* synthetic */ DockerApplicationRuntime val$applicationRuntime;
                    {
                        this.val$config = dockerAgentContainerConfig;
                        this.val$applicationRuntime = dockerApplicationRuntime;
                    }

                    @Override
                    protected DockerRuntimeEditorBase createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                        return new DockerPropertiesRuntimeEditor(this.val$config, this.val$applicationRuntime, callback);
                    }
                }.createContent();
                this.myEnvVarsContent = new EditorContentCreator((DockerAgentContainerConfig)config){
                    final /* synthetic */ DockerAgentContainerConfig val$config;
                    {
                        this.val$config = dockerAgentContainerConfig;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                        return new DockerEnvVarsRuntimeEditor(this.val$config, callback);
                    }
                }.createContent();
                this.myPortBindingContent = new EditorContentCreator((DockerAgentContainerConfig)config){
                    final /* synthetic */ DockerAgentContainerConfig val$config;
                    {
                        this.val$config = dockerAgentContainerConfig;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                        return new DockerPortBindingRuntimeEditor(this.val$config, callback);
                    }
                }.createContent();
                this.myVolumeBindingContent = new EditorContentCreator((DockerAgentContainerConfig)config){
                    final /* synthetic */ DockerAgentContainerConfig val$config;
                    {
                        this.val$config = dockerAgentContainerConfig;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                        return new DockerVolumeBindingsRuntimeEditor(this.val$config, callback, myDeployment.getConnection().getServer());
                    }
                }.createContent();
            })));
        }

        private void removeOldContent(Content content) {
            if (content != null) {
                this.myManager.removeFromSelection(content);
                this.myManager.removeContent(content, true);
            }
        }

        private void selectContainerLog() {
            ServerConnection connection = this.myDeployment.getConnection();
            connection.computeDeployments(() -> UIUtil.invokeLaterIfNeeded(() -> {
                String newContainerId = this.getRuntime().getContainerId();
                ServerConnection connection1 = this.myDeployment.getConnection();
                for (Deployment newDeployment : connection1.getDeployments()) {
                    DockerApplicationRuntime newDeploymentRuntime = (DockerApplicationRuntime)newDeployment.getRuntime();
                    if (newDeploymentRuntime == null || !StringUtil.equals((CharSequence)newDeploymentRuntime.getContainerId(), (CharSequence)newContainerId)) continue;
                    this.myNodeSelector.select(connection1, newDeployment.getName(), "Log");
                    break;
                }
            }));
        }

        private void doInitImageContent() {
            this.removeOldContent(this.myImagePropsContent);
            this.myImagePropsContent = new EditorContentCreator(){

                @Override
                protected DockerRuntimeEditorBase createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                    return new DockerPropertiesRuntimeEditor(null, this.getRuntime(), null);
                }
            }.createContent();
        }

        public void updateLogs() {
            if (!this.myContentInitialized) {
                return;
            }
            DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)this.myDeployment.getConnection().getLogManager(this.myProject, this.myDeployment);
            if (logManager == null) {
                this.removeAllDisposedLogsContent();
                return;
            }
            for (LoggingHandlerBase nextHandler : logManager.getAdditionalLoggingHandlers()) {
                if (DeploymentContent.isFinished(nextHandler)) continue;
                if ("Log".equals(nextHandler.getPresentableName())) {
                    this.initLogContent(nextHandler);
                    continue;
                }
                Content existing = this.findExistingContent(nextHandler);
                if (existing != null) continue;
                JComponent handlerUI = nextHandler.getComponent();
                Content reusable = this.findReusableContent(nextHandler);
                if (reusable != null) {
                    reusable.setComponent(handlerUI);
                    DeploymentContent.attachToContent(reusable, nextHandler);
                    continue;
                }
                Content content = this.myManager.getFactory().createContent(handlerUI, nextHandler.getPresentableName(), true);
                DeploymentContent.attachToContent(content, nextHandler);
                this.myManager.addContent(content);
            }
            if (this.getRuntime() != null && this.getRuntime().getStatus() == DeploymentStatus.DEPLOYED && DeploymentContent.allLoggingHandlersFinished(logManager)) {
                this.getRuntime().showLog(this.myProject, EmptyRunnable.getInstance());
            }
        }

        private static boolean allLoggingHandlersFinished(@NotNull DeploymentLogManagerImpl logManager) {
            if (logManager == null) {
                DeploymentContent.$$$reportNull$$$0(3);
            }
            return logManager.getAdditionalLoggingHandlers().stream().filter(it -> "Log".equals(it.getPresentableName())).allMatch(it -> DeploymentContent.isFinished(it));
        }

        private static boolean isFinished(LoggingHandlerBase handler) {
            return Disposer.isDisposed((Disposable)handler) || handler.isClosed();
        }

        private static void attachToContent(@NotNull Content content, @NotNull LoggingHandlerBase loggingHandler) {
            if (content == null) {
                DeploymentContent.$$$reportNull$$$0(4);
            }
            if (loggingHandler == null) {
                DeploymentContent.$$$reportNull$$$0(5);
            }
            content.setPreferredFocusedComponent(() -> ((LoggingHandlerBase)loggingHandler).getPreferredFocusableComponent());
            content.putUserData(ADDITIONAL_LOG_KEY, (Object)loggingHandler);
        }

        private static boolean shouldReuseClosedContent(@NotNull LoggingHandlerBase handler) {
            String key;
            if (handler == null) {
                DeploymentContent.$$$reportNull$$$0(6);
            }
            if ((key = handler.getPresentableName()) == null) {
                return false;
            }
            switch (key) {
                case "Log": 
                case "Attached console": {
                    return true;
                }
            }
            return false;
        }

        private void initLogContent(@NotNull LoggingHandlerBase loggingHandler) {
            if (loggingHandler == null) {
                DeploymentContent.$$$reportNull$$$0(7);
            }
            assert (!loggingHandler.isClosed());
            if (this.myLogPanel.getComponentCount() == 0) {
                this.myLogPanel.add((Component)loggingHandler.getComponent(), "Center");
                DeploymentContent.attachToContent(this.myLogContent, loggingHandler);
            } else {
                LoggingHandlerBase oldHandler = (LoggingHandlerBase)this.myLogContent.getUserData(ADDITIONAL_LOG_KEY);
                if (oldHandler == loggingHandler || oldHandler != null && !oldHandler.isClosed()) {
                    return;
                }
                if (oldHandler != null) {
                    this.myLogPanel.remove(oldHandler.getComponent());
                    DeploymentContent.attachToContent(this.myLogContent, loggingHandler);
                    this.myLogPanel.add((Component)loggingHandler.getComponent(), "Center");
                }
            }
            this.replaceLogToolbar(loggingHandler);
            this.myLogPanel.revalidate();
        }

        @NotNull
        private static AnAction[] getToolbarActions(LoggingHandlerBase loggingHandler) {
            AnAction[] anActionArray = loggingHandler instanceof LoggingHandlerImpl ? ((LoggingHandlerImpl)loggingHandler).getConsole().createConsoleActions() : AnAction.EMPTY_ARRAY;
            if (anActionArray == null) {
                DeploymentContent.$$$reportNull$$$0(8);
            }
            return anActionArray;
        }

        private void removeAllDisposedLogsContent() {
            for (Content content : this.myManager.getContents()) {
                LoggingHandlerBase additionalLog = (LoggingHandlerBase)content.getUserData(ADDITIONAL_LOG_KEY);
                if (additionalLog == null) continue;
                assert (Disposer.isDisposed((Disposable)additionalLog)) : "Without manager but not disposed: " + additionalLog.getPresentableName();
                this.removeOldContent(content);
            }
        }

        private void replaceLogToolbar(@NotNull LoggingHandlerBase loggingHandler) {
            if (loggingHandler == null) {
                DeploymentContent.$$$reportNull$$$0(9);
            }
            if (this.myLogToolbar != null) {
                this.myLogPanel.remove(this.myLogToolbar);
                this.myLogToolbar = null;
            }
            AnAction[] toolbarActions = DeploymentContent.getToolbarActions(loggingHandler);
            DefaultActionGroup actions = new DefaultActionGroup();
            for (AnAction next : toolbarActions) {
                actions.add(next);
            }
            this.myLogContent.setActions((ActionGroup)actions, TOOLBAR_PLACE, loggingHandler.getComponent());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(TOOLBAR_PLACE, (ActionGroup)actions, false);
            toolbar.setTargetComponent(loggingHandler.getComponent());
            this.myLogToolbar = toolbar.getComponent();
            this.myLogPanel.add((Component)this.myLogToolbar, "East");
        }

        @Nullable
        private Content findExistingContent(@NotNull LoggingHandlerBase handler) {
            if (handler == null) {
                DeploymentContent.$$$reportNull$$$0(10);
            }
            for (Content next : this.myManager.getContents()) {
                LoggingHandlerBase nextHandler = (LoggingHandlerBase)next.getUserData(ADDITIONAL_LOG_KEY);
                if (nextHandler != handler) continue;
                return next;
            }
            return null;
        }

        @Nullable
        private Content findReusableContent(@NotNull LoggingHandlerBase handler) {
            if (handler == null) {
                DeploymentContent.$$$reportNull$$$0(11);
            }
            if (!DeploymentContent.shouldReuseClosedContent(handler)) {
                return null;
            }
            String keyToFind = handler.getPresentableName();
            if (keyToFind == null) {
                return null;
            }
            for (Content next : this.myManager.getContents()) {
                LoggingHandlerBase nextHandler = (LoggingHandlerBase)next.getUserData(ADDITIONAL_LOG_KEY);
                if (nextHandler == null || !nextHandler.isClosed() || !keyToFind.equals(nextHandler.getPresentableName())) continue;
                return next;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeSelector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logManager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loggingHandler";
                    break;
                }
                case 6: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/DockerTreeStructure$DeploymentContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/DockerTreeStructure$DeploymentContent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolbarActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "allLoggingHandlersFinished";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToContent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldReuseClosedContent";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "initLogContent";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceLogToolbar";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findExistingContent";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findReusableContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DockerTabContentListener
        extends ContentManagerAdapter {
            private final DeploymentLogManager myLogManager;

            DockerTabContentListener(@NotNull DeploymentLogManager logManager) {
                if (logManager == null) {
                    DockerTabContentListener.$$$reportNull$$$0(0);
                }
                this.myLogManager = logManager;
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                Content content;
                LoggingHandlerBase additionalLog;
                TerminalHandlerBase terminalHandler;
                if (event == null) {
                    DockerTabContentListener.$$$reportNull$$$0(1);
                }
                if ((terminalHandler = (TerminalHandlerBase)ObjectUtils.tryCast((Object)(additionalLog = (LoggingHandlerBase)(content = event.getContent()).getUserData(ADDITIONAL_LOG_KEY)), TerminalHandlerBase.class)) != null) {
                    terminalHandler.close();
                }
                if (additionalLog != null && content.isCloseable()) {
                    this.myLogManager.removeAdditionalLog(additionalLog.getPresentableName());
                    Disposer.dispose((Disposable)additionalLog);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "logManager";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/view/DockerTreeStructure$DeploymentContent$DockerTabContentListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private abstract class EditorContentCreator {
            private EditorContentCreator() {
            }

            public Content createContent() {
                DockerRuntimeEditorBase editor = this.createEditor((ParameterizedRunnable<DockerAgentContainerConfig>)((ParameterizedRunnable)config -> DeploymentContent.this.getRuntime().updateContainer((DockerAgentContainerConfig)config, () -> {
                    DeploymentContent.this.myContentInitialized = false;
                    DeploymentContent.this.selectContainerLog();
                })));
                Content result = DeploymentContent.this.myManager.getFactory().createContent((JComponent)editor.getMainPanel(), editor.getName(), true);
                result.setCloseable(false);
                DeploymentContent.this.myManager.addContent(result);
                return result;
            }

            protected abstract DockerRuntimeEditorBase createEditor(ParameterizedRunnable<DockerAgentContainerConfig> var1);
        }
    }

    public class DockerDeploymentNode
    extends ServersTreeStructure.DeploymentNodeImpl {
        private final DeploymentContent myContent;

        protected DockerDeploymentNode(@NotNull ServerConnection<?> connection, @NotNull ServersTreeStructure.RemoteServerNode serverNode, Deployment value) {
            if (connection == null) {
                DockerDeploymentNode.$$$reportNull$$$0(0);
            }
            if (serverNode == null) {
                DockerDeploymentNode.$$$reportNull$$$0(1);
            }
            if (value == null) {
                DockerDeploymentNode.$$$reportNull$$$0(2);
            }
            super((ServersTreeStructure)DockerTreeStructure.this, connection, serverNode, value);
            this.myContent = DockerTreeStructure.this.myDeployment2Content.computeIfAbsent(value, this::createDeploymentContent);
            this.myContent.initContent();
            this.myContent.updateLogs();
        }

        @NotNull
        private DeploymentContent createDeploymentContent(@NotNull Deployment deployment) {
            if (deployment == null) {
                DockerDeploymentNode.$$$reportNull$$$0(3);
            }
            DeploymentContent deploymentContent = new DeploymentContent(DockerTreeStructure.this.doGetProject(), deployment, DockerTreeStructure.this.getNodeSelector());
            if (deploymentContent == null) {
                DockerDeploymentNode.$$$reportNull$$$0(4);
            }
            return deploymentContent;
        }

        @Nullable
        public JComponent getComponent() {
            this.myContent.show();
            return this.myContent.getManager().getComponent();
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList result = new ArrayList();
            this.collectDeploymentChildren(result);
            Collection collection = result.stream().filter(DockerTreeFilter.getInstance()::acceptNode).filter(node -> !this.isUndeployedDockerNode((AbstractTreeNode)node)).collect(Collectors.toList());
            if (collection == null) {
                DockerDeploymentNode.$$$reportNull$$$0(5);
            }
            return collection;
        }

        private boolean isUndeployedDockerNode(@Nullable AbstractTreeNode node) {
            Deployment deployment = Optional.ofNullable(node).map(o -> (DockerDeploymentNode)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerDeploymentNode.class)))).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).orElse(null);
            return deployment != null && DockerDeploymentStatus.DELETED.matches(deployment) && deployment.getRuntime() instanceof DockerDeploymentRuntime;
        }

        public void selectLog(String logName) {
            ContentManager contentManager = this.myContent.getManager();
            Content[] allContents = contentManager.getContents();
            for (int i = allContents.length - 1; i >= 0; --i) {
                Content content = allContents[i];
                LoggingHandlerBase additionalLog = (LoggingHandlerBase)content.getUserData(ADDITIONAL_LOG_KEY);
                if (additionalLog == null || !StringUtil.equals((CharSequence)additionalLog.getPresentableName(), (CharSequence)logName)) continue;
                contentManager.setSelectedContent(content, true);
                return;
            }
        }

        protected void update(@NotNull PresentationData presentation) {
            ComposeServiceRuntime serviceRuntime;
            if (presentation == null) {
                DockerDeploymentNode.$$$reportNull$$$0(6);
            }
            super.update(presentation);
            Deployment deployment = this.getDeployment();
            DockerApplicationRuntime runtime = (DockerApplicationRuntime)deployment.getRuntime();
            if (deployment.getStatus() == DeploymentStatus.DEPLOYED) {
                Icon icon = runtime != null && runtime.getStatus() == DockerDeploymentStatus.IMAGE.getStatus() ? DockerIcons.SingleImage : DockerIcons.SingleRunningContainer;
                presentation.setIcon(icon);
            }
            if ((serviceRuntime = (ComposeServiceRuntime)ObjectUtils.tryCast((Object)((Object)runtime), ComposeServiceRuntime.class)) != null) {
                presentation.setPresentableText(serviceRuntime.getServiceName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployment";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/DockerTreeStructure$DockerDeploymentNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/DockerTreeStructure$DockerDeploymentNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDeploymentContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDeploymentContent";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

