require 'test/unit'

module Borges;end
require 'Borges/Callback/Callback'
require 'Borges/Callback/DispatchCallback'
require 'Borges/Callback/CallbackStore'

class DispatchCallbackTest < Test::Unit::TestCase

  def setup
    @callback = Borges::DispatchCallback.new
  end

  def test_dispatch_callback?
    assert @callback.dispatch_callback?, "Is a dispatch callback"
  end

  def test_evaluate
    x = nil
    req = Object.new
    class << req
      def fields; [["0", "1"]]; end
    end

    @store = Borges::CallbackStore.new
    @store.register_dispatch_callback
    @store.register_callback do x = "value" end
    @store.process_request req

    assert_equal "value", x, "Dispatch to ValueCallback"
  end

end # class DispatchCallbackTest


