// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collection;

/**
 * Extension point will be called for any unresolved PhpReference
 * @since 2017.3
 * WillBe removed in 2018.3
 * @see PhpReferenceResolver2
 */
@ApiStatus.ScheduledForRemoval
public interface PhpReferenceResolver {

  ExtensionPointName<PhpReferenceResolver> EP_NAME = ExtensionPointName.create("com.jetbrains.php.referenceResolver");

  Collection<? extends PhpNamedElement> resolve(PhpReference reference);
}
