/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.SubTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResolvingConverter<T>
extends Converter<T>
implements ResolvingHint {
    @Deprecated
    public static final ResolvingConverter EMPTY_CONVERTER = new ResolvingConverter(){

        @NotNull
        public Collection getVariants(ConvertContext context) {
            List list = Collections.emptyList();
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public Object fromString(String s, ConvertContext context) {
            return s;
        }

        @Override
        public String toString(Object t, ConvertContext context) {
            return String.valueOf(t);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ResolvingConverter$1", "getVariants"));
        }
    };
    @Deprecated
    public static final Converter<Boolean> BOOLEAN_CONVERTER = new ResolvingConverter<Boolean>(){

        @Override
        public Boolean fromString(String s, ConvertContext context) {
            if ("true".equalsIgnoreCase(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s)) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public String toString(Boolean t, ConvertContext context) {
            return t == null ? null : t.toString();
        }

        @Override
        @NotNull
        public Collection<? extends Boolean> getVariants(ConvertContext context) {
            SubTag annotation;
            DomElement element = context.getInvocationElement();
            if (element instanceof GenericDomValue && (annotation = element.getAnnotation(SubTag.class)) != null && annotation.indicator()) {
                List list = Collections.emptyList();
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<Boolean> list = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
            if (list == null) {
                2.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ResolvingConverter$2", "getVariants"));
        }
    };

    @Override
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.default.message", (Object[])new Object[]{s});
    }

    @NotNull
    public abstract Collection<? extends T> getVariants(ConvertContext var1);

    @Deprecated
    @NotNull
    public Set<String> getAdditionalVariants() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ResolvingConverter.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            ResolvingConverter.$$$reportNull$$$0(1);
        }
        Set<String> set = this.getAdditionalVariants();
        if (set == null) {
            ResolvingConverter.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void handleElementRename(GenericDomValue<T> genericValue, ConvertContext context, String newElementName) {
        genericValue.setStringValue(newElementName);
    }

    public void bindReference(GenericDomValue<T> genericValue, ConvertContext context, PsiElement newTarget) {
        DomElement domElement;
        if (newTarget instanceof XmlTag && (domElement = genericValue.getManager().getDomElement((XmlTag)newTarget)) != null) {
            genericValue.setStringValue(ElementPresentationManager.getElementName(domElement));
        }
    }

    @Nullable
    public PsiElement getPsiElement(@Nullable T resolvedValue) {
        if (resolvedValue instanceof PsiElement) {
            return (PsiElement)resolvedValue;
        }
        if (resolvedValue instanceof DomElement) {
            return ((DomElement)resolvedValue).getXmlElement();
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, @Nullable T resolveResult, ConvertContext context) {
        if (element == null) {
            ResolvingConverter.$$$reportNull$$$0(3);
        }
        return resolveResult != null && element.getManager().areElementsEquivalent(element, this.getPsiElement(resolveResult));
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return true;
    }

    @Nullable
    public PsiElement resolve(T o, ConvertContext context) {
        PsiElement psiElement = this.getPsiElement(o);
        return psiElement == null && o != null ? DomUtil.getValueElement((GenericDomValue)context.getInvocationElement()) : psiElement;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    public LookupElement createLookupElement(T t) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/ResolvingConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalVariants";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/ResolvingConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class WrappedResolvingConverter<T>
    extends ResolvingConverter<T> {
        private final Converter<T> myWrappedConverter;

        public WrappedResolvingConverter(Converter<T> converter) {
            this.myWrappedConverter = converter;
        }

        @Override
        public T fromString(String s, ConvertContext context) {
            return this.myWrappedConverter.fromString(s, context);
        }

        @Override
        public String toString(T t, ConvertContext context) {
            return this.myWrappedConverter.toString(t, context);
        }
    }

    public static abstract class StringConverter
    extends ResolvingConverter<String> {
        @Override
        public String fromString(String s, ConvertContext context) {
            return s;
        }

        @Override
        public String toString(String s, ConvertContext context) {
            return s;
        }
    }
}

