/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.codeStyle;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpPredefinedCodeStyleBase;
import com.jetbrains.php.refactoring.PhpNameStyle;
import org.jetbrains.annotations.NotNull;

public class JoomlaPredefinedCodeStyle
extends PhpPredefinedCodeStyleBase {
    public JoomlaPredefinedCodeStyle() {
        super("Joomla!");
    }

    public JoomlaPredefinedCodeStyle(@NotNull String name) {
        if (name == null) {
            JoomlaPredefinedCodeStyle.$$$reportNull$$$0(0);
        }
        super(name);
    }

    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpSettings.ALIGN_KEY_VALUE_PAIRS = true;
        phpSettings.ALIGN_PHPDOC_PARAM_NAMES = true;
        phpSettings.ALIGN_PHPDOC_COMMENTS = true;
        phpSettings.ALIGN_ASSIGNMENTS = true;
        phpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS = true;
        phpSettings.LOWER_CASE_BOOLEAN_CONST = true;
        phpSettings.LOWER_CASE_NULL_CONST = true;
        phpSettings.BLANK_LINES_BEFORE_RETURN_STATEMENT = 1;
        phpSettings.VARIABLE_NAMING_STYLE = PhpNameStyle.Style.CAMEL_CASE;
        phpSettings.IF_LPAREN_ON_NEXT_LINE = false;
        phpSettings.IF_RPAREN_ON_NEXT_LINE = false;
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
        commonSettings.BRACE_STYLE = 2;
        commonSettings.ELSE_ON_NEW_LINE = true;
        commonSettings.CATCH_ON_NEW_LINE = true;
        commonSettings.SPACE_AFTER_TYPE_CAST = true;
        CommonCodeStyleSettings.IndentOptions commonIndentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
        commonIndentOptions.USE_TAB_CHARACTER = true;
        commonIndentOptions.SMART_TABS = true;
        CommonCodeStyleSettings.IndentOptions otherIndentOptions = settings.OTHER_INDENT_OPTIONS;
        otherIndentOptions.INDENT_SIZE = 4;
        otherIndentOptions.CONTINUATION_INDENT_SIZE = 8;
        otherIndentOptions.TAB_SIZE = 4;
        otherIndentOptions.USE_TAB_CHARACTER = true;
        otherIndentOptions.SMART_TABS = false;
        otherIndentOptions.LABEL_INDENT_SIZE = 0;
        otherIndentOptions.LABEL_INDENT_ABSOLUTE = false;
        otherIndentOptions.USE_RELATIVE_INDENTS = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/joomla/codeStyle/JoomlaPredefinedCodeStyle", "<init>"));
    }
}

