/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.SpacingItem;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import com.intellij.ui.mac.touchbar.TBItemPopover;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ItemsContainer {
    @NotNull
    private final String myName;
    @Nullable
    private final ItemListener myListener;
    @NotNull
    private final List<TBItem> myItems;
    private long myCounter;

    ItemsContainer(@NotNull String name, @Nullable ItemListener listener2) {
        if (name == null) {
            ItemsContainer.$$$reportNull$$$0(0);
        }
        this.myItems = new ArrayList<TBItem>();
        this.myCounter = 0L;
        this.myName = name;
        this.myListener = listener2;
    }

    boolean isEmpty() {
        return this.myItems.isEmpty();
    }

    boolean hasAnActionItems() {
        return this.anyMatchDeep(item -> item instanceof TBItemAnActionButton);
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    TBItemButton addButton() {
        TBItemButton butt = new TBItemButton(this._genNewID("button"), this.myListener);
        this.myItems.add(butt);
        TBItemButton tBItemButton = butt;
        if (tBItemButton == null) {
            ItemsContainer.$$$reportNull$$$0(1);
        }
        return tBItemButton;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act, @Nullable TBItem positionAnchor) {
        if (act == null) {
            ItemsContainer.$$$reportNull$$$0(2);
        }
        String actId = ApplicationManager.getApplication() != null ? ActionManager.getInstance().getId(act) : act.toString();
        String uid = String.format("%s.anActionButton.%d.%s", this.myName, this.myCounter++, actId);
        TBItemAnActionButton butt = new TBItemAnActionButton(uid, this.myListener, act);
        if (positionAnchor != null) {
            int index = this.myItems.indexOf(positionAnchor);
            if (index >= 0 && index < this.myItems.size()) {
                this.myItems.add(index, butt);
            } else {
                this.myItems.add(butt);
            }
        } else {
            this.myItems.add(butt);
        }
        TBItemAnActionButton tBItemAnActionButton = butt;
        if (tBItemAnActionButton == null) {
            ItemsContainer.$$$reportNull$$$0(3);
        }
        return tBItemAnActionButton;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act) {
        if (act == null) {
            ItemsContainer.$$$reportNull$$$0(4);
        }
        TBItemAnActionButton tBItemAnActionButton = this.addAnActionButton(act, null);
        if (tBItemAnActionButton == null) {
            ItemsContainer.$$$reportNull$$$0(5);
        }
        return tBItemAnActionButton;
    }

    @NotNull
    TBItemGroup addGroup() {
        TBItemGroup group = new TBItemGroup(this._genNewID("group"), this.myListener);
        this.myItems.add(group);
        TBItemGroup tBItemGroup = group;
        if (tBItemGroup == null) {
            ItemsContainer.$$$reportNull$$$0(6);
        }
        return tBItemGroup;
    }

    @NotNull
    TBItemPopover addPopover(Icon icon, String text, int width, TouchBar expandTB, TouchBar tapAndHoldTB) {
        TBItemPopover popover = new TBItemPopover(this._genNewID("popover"), this.myListener, icon, text, width, expandTB, tapAndHoldTB);
        this.myItems.add(popover);
        TBItemPopover tBItemPopover = popover;
        if (tBItemPopover == null) {
            ItemsContainer.$$$reportNull$$$0(7);
        }
        return tBItemPopover;
    }

    @NotNull
    TBItemScrubber addScrubber() {
        int defaultScrubberWidth = 500;
        TBItemScrubber scrubber = new TBItemScrubber(this._genNewID("scrubber"), this.myListener, 500);
        this.myItems.add(scrubber);
        TBItemScrubber tBItemScrubber = scrubber;
        if (tBItemScrubber == null) {
            ItemsContainer.$$$reportNull$$$0(8);
        }
        return tBItemScrubber;
    }

    void addSpacing(boolean large) {
        SpacingItem spacing = new SpacingItem(large ? "static_touchbar_item_large_space" : "static_touchbar_item_small_space");
        this.myItems.add(spacing);
    }

    void addFlexibleSpacing() {
        SpacingItem spacing = new SpacingItem("static_touchbar_item_flexible_space");
        this.myItems.add(spacing);
    }

    void releaseAll() {
        this.myItems.forEach(item -> item.releaseNativePeer());
        this.myItems.clear();
    }

    void remove(@Nullable Predicate<TBItem> filter) {
        if (filter == null) {
            this.releaseAll();
            return;
        }
        Iterator<TBItem> i = this.myItems.iterator();
        while (i.hasNext()) {
            TBItem item = i.next();
            boolean removeGroup = false;
            if (item instanceof TBItemGroup) {
                ItemsContainer group = ((TBItemGroup)item).getContainer();
                group.remove(filter);
                if (group.isEmpty()) {
                    removeGroup = true;
                }
            }
            if (!removeGroup && !filter.test(item)) continue;
            item.releaseNativePeer();
            i.remove();
        }
    }

    @NotNull
    String[] getVisibleIds() {
        String[] ids = new String[this.myItems.size()];
        int c = 0;
        for (TBItem item : this.myItems) {
            if (!item.myIsVisible) continue;
            ids[c++] = item.myUid;
        }
        String[] stringArray = c == this.myItems.size() ? ids : Arrays.copyOf(ids, c);
        if (stringArray == null) {
            ItemsContainer.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @NotNull
    ID[] getVisibleNativePeers() {
        ID[] ids = new ID[this.myItems.size()];
        int c = 0;
        for (TBItem item : this.myItems) {
            if (!item.myIsVisible || ID.NIL.equals((Object)item.getNativePeer())) continue;
            ids[c++] = item.getNativePeer();
        }
        ID[] iDArray = c == this.myItems.size() ? ids : Arrays.copyOf(ids, c);
        if (iDArray == null) {
            ItemsContainer.$$$reportNull$$$0(10);
        }
        return iDArray;
    }

    void forEachDeep(Consumer<? super TBItem> proc) {
        this.myItems.forEach(item -> {
            if (item instanceof TBItemGroup) {
                ((TBItemGroup)item).getContainer().forEachDeep(proc);
                return;
            }
            proc.accept((TBItem)item);
        });
    }

    boolean anyMatchDeep(Predicate<? super TBItem> proc) {
        return this.myItems.stream().anyMatch(item -> {
            if (item instanceof TBItemGroup) {
                return ((TBItemGroup)item).getContainer().anyMatchDeep(proc);
            }
            return proc.test((TBItem)item);
        });
    }

    int releaseItems(Predicate<? super TBItem> proc) {
        Iterator<TBItem> i = this.myItems.iterator();
        int count = 0;
        while (i.hasNext()) {
            TBItem tbi = i.next();
            if (!proc.test(tbi)) continue;
            ++count;
            i.remove();
            tbi.releaseNativePeer();
        }
        return count;
    }

    @Nullable
    TBItem findItem(String uid) {
        for (TBItem item : this.myItems) {
            if (!item.myUid.equals(uid)) continue;
            return item;
        }
        return null;
    }

    @NotNull
    private String _genNewID(String desc) {
        String string = String.format("%s.%s.%d", this.myName, desc, this.myCounter++);
        if (string == null) {
            ItemsContainer.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/ItemsContainer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "act";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/ItemsContainer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addButton";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnActionButton";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addPopover";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addScrubber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleIds";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleNativePeers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "_genNewID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAnActionButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

