/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.mssql.Ms05Domains;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.Nullable;

public class Ms08Domains
extends Ms05Domains {
    private static final int MAX_TIME_FRACTION = 7;

    public Ms08Domains() {
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 7, 7, true));
        this.add(new FractionDomain("datetime2", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 3));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
    }

    @Override
    public boolean isSuitable(@Nullable Version productVersion) {
        return productVersion == null || DataSourceUiUtil.isMsSql2008(productVersion);
    }
}

