/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LangScriptingContextProvider {
    @NotNull
    public abstract Language getLanguage();

    public abstract PersistentLibraryKind getLibraryKind();

    public abstract ScriptingLibraryManager getLibraryManager(Project var1);

    public abstract boolean acceptsExtension(String var1);

    public abstract ScriptingLibraryMappings getLibraryMappings(Project var1);

    public abstract boolean isCompact(VirtualFile var1);

    @Nullable
    public abstract String getLibraryTypeName(OrderRootType var1);

    @Nullable
    public abstract String getDefaultDocUrl(@NotNull ScriptingFrameworkDescriptor var1);

    @Nullable
    public abstract ScriptingFrameworkDescriptor detectFramework(@NotNull VirtualFile var1);

    @Nullable
    public abstract String getOfflineDocUrl(String var1);

    public abstract void downloadOfflineDoc(@NotNull Project var1, @NotNull String var2, @Nullable Component var3, @NotNull Consumer<? super File> var4);

    @NotNull
    public abstract DownloadableFileSetVersions<DownloadableFileSetDescription> getDownloadableLibraryDescriptors(Project var1);

    public abstract void downloadLibrary(@NotNull Project var1, @NotNull DownloadableFileSetDescription var2, @Nullable Component var3, @Nullable Runnable var4);

    public abstract void filterExistingLibraries(@NotNull Project var1, @NotNull List<? extends DownloadableFileSetDescription> var2);

    public static String getIdeLibraryName(DownloadableFileSetDescription description) {
        String string = description.getName();
        String string2 = description.getVersionString();
        return string + "-" + string2;
    }

    @Nullable
    public ScriptingFrameworkDescriptor[] getSupportedFrameworks(Project project) {
        return ScriptingFrameworkDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public abstract Icon getFileIcon();
}

