/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DefinesXml;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.dom.DomElementXmlDescriptor;
import org.jetbrains.annotations.Nullable;

public class DomDescriptorProvider
implements XmlElementDescriptorProvider {
    @Nullable
    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        Project project = tag.getProject();
        if (project.isDefault()) {
            return null;
        }
        DomInvocationHandler domInvocationHandler = DomManagerImpl.getDomManager(project).getDomHandler((XmlElement)tag);
        if (domInvocationHandler != null) {
            XmlElementDescriptor xmlElementDescriptor;
            DefinesXml definesXml = domInvocationHandler.getAnnotation(DefinesXml.class);
            if (definesXml != null) {
                return new DomElementXmlDescriptor(domInvocationHandler);
            }
            PsiElement psiElement = tag.getParent();
            if (psiElement instanceof XmlTag && (xmlElementDescriptor = ((XmlTag)psiElement).getDescriptor()) instanceof DomElementXmlDescriptor) {
                return xmlElementDescriptor.getElementDescriptor(tag, (XmlTag)psiElement);
            }
        }
        return null;
    }
}

