/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.execution.ExecutionException;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CaseCollector;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.tools.quality.QualityToolAnnotationAppender;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolAnnotator
extends ExternalAnnotator<QualityToolAnnotatorInfo, QualityToolMessageProcessor> {
    private static final Logger LOG = Logger.getInstance(QualityToolAnnotator.class);
    private static final String GROUP_ID = "PHP External Quality Tools";

    public final QualityToolAnnotatorInfo collectAnnotatorInfo(@NotNull PsiFile file, @Nullable Editor editor, boolean isOnTheFly) {
        int caretPos;
        PsiElement currElement;
        String id;
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(0);
        }
        if (!this.isFileSuitable(file)) {
            return null;
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        LocalInspectionToolWrapper localInspectionToolWrapper = (LocalInspectionToolWrapper)inspectionProfile.getInspectionTool(id = this.getInspectionId(), (PsiElement)file);
        if (localInspectionToolWrapper == null || isOnTheFly && !inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)id), (PsiElement)file)) {
            return null;
        }
        LocalInspectionTool tool = (LocalInspectionTool)localInspectionToolWrapper.getTool();
        if (SuppressionUtil.inspectionResultSuppressed((PsiElement)file, (LocalInspectionTool)tool)) {
            return null;
        }
        Project project = file.getProject();
        QualityToolConfiguration configuration = this.getConfiguration(project, tool);
        if (configuration == null || StringUtil.isEmpty((String)configuration.getToolPath())) {
            return null;
        }
        if (!isOnTheFly && StringUtil.isNotEmpty((String)configuration.getInterpreterId())) {
            String interpreterId = configuration.getInterpreterId();
            PhpSdkAdditionalData data = PhpInterpretersManagerImpl.getInstance(project).findInterpreterDataById(interpreterId);
            if (data instanceof RemoteSdkAdditionalData && !CaseCollector.useRemoteCredentials((RemoteSdkAdditionalData)((RemoteSdkAdditionalData)data))) {
                return null;
            }
        }
        QualityToolAnnotatorInfo info = new QualityToolAnnotatorInfo(file, (QualityToolValidationInspection)tool, project, configuration, isOnTheFly);
        if (isOnTheFly && editor != null && (currElement = file.findElementAt((caretPos = editor.getCaretModel().getOffset()) - 1)) != null) {
            PsiElement parent;
            for (parent = currElement; parent != null && !PhpElementTypes.ANY_GROUP_STATEMENT.contains(parent.getNode().getElementType()) && !(parent instanceof PsiFile); parent = parent.getParent()) {
            }
            if (parent == null) {
                parent = file;
            }
            info.setContextElement(parent);
        }
        return info;
    }

    protected boolean isFileSuitable(@NotNull PsiFile file) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(1);
        }
        return file instanceof PhpFile && file.getViewProvider().getBaseLanguage() == PhpLanguage.INSTANCE && file.getContext() == null;
    }

    @Nullable
    public QualityToolAnnotatorInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            QualityToolAnnotator.$$$reportNull$$$0(3);
        }
        return hasErrors ? null : this.collectAnnotatorInfo(file, editor, true);
    }

    @Deprecated
    @Nullable
    protected QualityToolConfiguration getConfiguration(@NotNull Project project) {
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    protected QualityToolConfiguration getConfiguration(@NotNull Project project, @NotNull LocalInspectionTool inspection) {
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(5);
        }
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(6);
        }
        return this.getConfiguration(project);
    }

    @NotNull
    protected abstract String getTemporaryFilesFolder();

    @NotNull
    protected abstract String getInspectionId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final QualityToolMessageProcessor doAnnotate(QualityToolAnnotatorInfo collectedInfo) {
        if (!this.isContextValid(collectedInfo)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.testTool(collectedInfo);
        }
        String id = collectedInfo.getInterpreterId();
        PhpSdkAdditionalData sdkData = StringUtil.isEmpty((String)id) ? null : PhpInterpretersManagerImpl.getInstance(collectedInfo.getProject()).findInterpreterDataById(id);
        PhpSdkFileTransfer transfer = PhpSdkFileTransfer.getSdkFileTransfer(sdkData);
        ProgressManager.checkCanceled();
        try {
            this.createTempFile(collectedInfo, transfer);
        }
        catch (ExecutionException e) {
            QualityToolAnnotator.showProcessErrorMessage(collectedInfo, StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message("quality.tool.can.not.create.temporary.file", new Object[0])));
            QualityToolAnnotator.logWarning(collectedInfo, "Can not create temporary file", (Exception)((Object)e));
            return null;
        }
        catch (IOException e) {
            QualityToolAnnotator.showProcessErrorMessage(collectedInfo, e.getMessage());
            QualityToolAnnotator.logWarning(collectedInfo, "Can not create temporary file", e);
            return null;
        }
        ProgressManager.checkCanceled();
        QualityToolMessageProcessor messageProcessor = this.createMessageProcessor(collectedInfo);
        try {
            this.runTool(messageProcessor, collectedInfo, transfer);
        }
        catch (ExecutionException e) {
            QualityToolAnnotator.showProcessErrorMessage(collectedInfo, e.getMessage());
            QualityToolAnnotator.logWarning(collectedInfo, "Can not execute quality tool", (Exception)((Object)e));
        }
        finally {
            try {
                QualityToolAnnotator.removeTempFile(collectedInfo, transfer);
            }
            catch (ExecutionException e) {
                QualityToolAnnotator.logWarning(collectedInfo, "Can not remove temporary file", (Exception)((Object)e));
            }
        }
        return messageProcessor.isFatalError() ? null : messageProcessor;
    }

    protected boolean isContextValid(QualityToolAnnotatorInfo collectedInfo) {
        return collectedInfo != null && !collectedInfo.getProject().isDisposed() && new ContextValidator().isValid((PsiElement)collectedInfo.getPsiFile()) && collectedInfo.getPsiFile().isValid();
    }

    public static void logWarning(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull String prefix, @Nullable Exception e) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            QualityToolAnnotator.$$$reportNull$$$0(8);
        }
        String message = prefix + " for '" + collectedInfo.getOriginalFile().getPath() + "' on " + QualityToolAnnotator.toPresentableLocation(collectedInfo);
        LOG.warn(message + (e == null ? "" : ": " + e.getMessage()));
    }

    private static String toPresentableLocation(@NotNull QualityToolAnnotatorInfo collectedInfo) {
        PhpInterpreter interpreter;
        Project project;
        String interpreterId;
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)(interpreterId = collectedInfo.getInterpreterId())) && !(project = collectedInfo.getProject()).isDisposed() && (interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId)) != null) {
            return interpreter.getPhpSdkAdditionalData().toPresentablePath();
        }
        return "local";
    }

    @Deprecated
    protected void runTool(@NotNull QualityToolMessageProcessor messageProcessor, @NotNull QualityToolAnnotatorInfo annotatorInfo) throws ExecutionException {
        if (messageProcessor == null) {
            QualityToolAnnotator.$$$reportNull$$$0(10);
        }
        if (annotatorInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(11);
        }
    }

    protected void runTool(@NotNull QualityToolMessageProcessor messageProcessor, @NotNull QualityToolAnnotatorInfo annotatorInfo, @NotNull PhpSdkFileTransfer transfer) throws ExecutionException {
        if (messageProcessor == null) {
            QualityToolAnnotator.$$$reportNull$$$0(12);
        }
        if (annotatorInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(13);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(14);
        }
        this.runTool(messageProcessor, annotatorInfo);
    }

    protected abstract QualityToolMessageProcessor createMessageProcessor(@NotNull QualityToolAnnotatorInfo var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private QualityToolMessageProcessor testTool(@NotNull QualityToolAnnotatorInfo annotatorInfo) {
        if (annotatorInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(15);
        }
        QualityToolMessageProcessor messageProcessor = this.createMessageProcessor(annotatorInfo);
        String id = annotatorInfo.getInterpreterId();
        PhpSdkAdditionalData sdkData = StringUtil.isEmpty((String)id) ? null : PhpInterpretersManagerImpl.getInstance(annotatorInfo.getProject()).findInterpreterDataById(id);
        PhpSdkFileTransfer transfer = PhpSdkFileTransfer.getSdkFileTransfer(sdkData);
        try {
            this.createTempFile(annotatorInfo, transfer);
            File testFile = new File(FileUtil.getNameWithoutExtension((String)annotatorInfo.getOriginalFile().getPath()) + ".txt");
            if (!testFile.exists()) {
                QualityToolMessageProcessor qualityToolMessageProcessor = null;
                return qualityToolMessageProcessor;
            }
            try (BufferedReader input = new BufferedReader(new InputStreamReader(new FileInputStream(testFile)));){
                input.lines().map(line -> line + '\n').forEach(messageProcessor::parseLine);
                messageProcessor.done();
            }
            QualityToolMessageProcessor qualityToolMessageProcessor = messageProcessor.isFatalError() ? null : messageProcessor;
            return qualityToolMessageProcessor;
        }
        catch (Exception e) {
            LOG.warn("Can not run quality tool: " + e.getMessage());
        }
        finally {
            try {
                QualityToolAnnotator.removeTempFile(annotatorInfo, transfer);
            }
            catch (ExecutionException e) {
                LOG.warn("Can not remove temporary file: " + e.getMessage());
            }
        }
        return null;
    }

    private void createTempFile(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull PhpSdkFileTransfer transfer) throws IOException, ExecutionException {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(16);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(17);
        }
        Project project = collectedInfo.getProject();
        String path = null;
        String basePath = project.getBasePath();
        String pathToOriginalFile = FileUtil.toSystemIndependentName((String)collectedInfo.getOriginalFile().getPath());
        if (StringUtil.isNotEmpty((String)basePath) && FileUtil.isAncestor((String)basePath, (String)pathToOriginalFile, (boolean)true)) {
            path = FileUtil.getRelativePath((String)basePath, (String)pathToOriginalFile, (char)'/');
        }
        if (StringUtil.isEmpty(path)) {
            path = collectedInfo.getOriginalFile().getName();
        }
        if (project.isDisposed()) {
            throw new ExecutionException("Cannot create file because project is already disposed");
        }
        String file = transfer.createFile(project, path, QualityToolAnnotator.getFileContent(collectedInfo.getPsiFile()), this.getTemporaryFilesFolder(), collectedInfo.getTimeout() / 2);
        collectedInfo.setTempFile(file);
    }

    private static String getFileContent(@NotNull PsiFile file) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(18);
        }
        return (String)ReadAction.compute(() -> {
            if (file == null) {
                QualityToolAnnotator.$$$reportNull$$$0(32);
            }
            return file.getText();
        });
    }

    private static void removeTempFile(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull PhpSdkFileTransfer transfer) throws ExecutionException {
        String tempFile;
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(19);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(20);
        }
        if ((tempFile = collectedInfo.getFile()) == null) {
            return;
        }
        boolean deleteTempDir = StringUtil.isEmpty((String)collectedInfo.getInterpreterId()) || collectedInfo.isOnTheFly();
        transfer.delete(collectedInfo.getProject(), collectedInfo.getTimeout() / 2, deleteTempDir);
    }

    public static void showProcessErrorMessage(final @NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull String messageText) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(21);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(22);
        }
        if (!collectedInfo.isOnTheFly() || collectedInfo.getProject().isDisposed()) {
            LOG.warn(messageText);
            return;
        }
        final QualityToolValidationInspection inspection = collectedInfo.getInspection();
        String text = messageText.replace("\n", "<br>") + (StringUtil.endsWith((CharSequence)messageText, (CharSequence)"</a>") ? " or " : "<br>") + "<a href='disable'>Disable inspection</a>";
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                if (notification2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                String description = event.getDescription();
                Project project = collectedInfo.getProject();
                if (!project.isDisposed()) {
                    if ("disable".equals(description)) {
                        InspectionProfileManager.getInstance((Project)project).getCurrentProfile().setToolEnabled(inspection.getID(), false);
                        this.showInfoNotification(inspection.getDisplayName() + " was disabled.");
                    } else if ("update".equals(description)) {
                        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(collectedInfo.getInterpreterId());
                        if (interpreter == null) {
                            this.showWarningNotification(PhpBundle.message("quality.tool.configuration.interpreter.is.undefined", inspection.getToolName()));
                            return;
                        }
                        try {
                            PhpSdkHelpersManager.getHelpersManager(interpreter.getPhpSdkAdditionalData()).update(project, null);
                            this.showInfoNotification(PhpBundle.message("quality.tool.configuration.interpreter.was.reloaded", new Object[0]));
                        }
                        catch (Exception e) {
                            this.showWarningNotification(e.getMessage());
                            LOG.warn((Throwable)e);
                        }
                    }
                }
            }

            private void showWarningNotification(@NotNull String warning) {
                if (warning == null) {
                    1.$$$reportNull$$$0(2);
                }
                Notifications.Bus.notify((Notification)new Notification(QualityToolAnnotator.GROUP_ID, inspection.getToolName(), warning, NotificationType.WARNING));
            }

            private void showInfoNotification(@NotNull String info) {
                if (info == null) {
                    1.$$$reportNull$$$0(3);
                }
                Notifications.Bus.notify((Notification)new Notification(QualityToolAnnotator.GROUP_ID, inspection.getToolName(), info, NotificationType.INFORMATION));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "warning";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hyperlinkUpdate";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showWarningNotification";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showInfoNotification";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        QualityToolAnnotator.showProcessErrorMessage(inspection, text, listener);
    }

    public static void showProcessErrorMessage(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull QualityToolBlackList blackList, @NotNull String messageText) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(23);
        }
        if (blackList == null) {
            QualityToolAnnotator.$$$reportNull$$$0(24);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(25);
        }
        QualityToolValidationInspection inspection = collectedInfo.getInspection();
        String text = messageText.replace("\n", "<br>") + "<br><a href=''>Exclude " + collectedInfo.getOriginalFile().getName() + " from " + inspection.getToolName() + " analysis.</a>";
        QualityToolAnnotator.showProcessErrorMessage(inspection, text, (notification2, event) -> {
            VirtualFile originalFile;
            if (collectedInfo == null) {
                QualityToolAnnotator.$$$reportNull$$$0(30);
            }
            if (blackList == null) {
                QualityToolAnnotator.$$$reportNull$$$0(31);
            }
            if (blackList.addFile(originalFile = collectedInfo.getOriginalFile())) {
                Notifications.Bus.notify((Notification)new Notification(GROUP_ID, inspection.getToolName(), originalFile.getName() + " added to ignored files list.", NotificationType.INFORMATION));
            }
        });
    }

    public static void showProcessErrorMessage(@NotNull QualityToolValidationInspection inspection, @NotNull String messageText, @Nullable NotificationListener listener) {
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(26);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(27);
        }
        Notifications.Bus.notify((Notification)new Notification(GROUP_ID, inspection.getToolName(), messageText, NotificationType.ERROR, listener));
    }

    public void apply(@NotNull PsiFile file, QualityToolMessageProcessor annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(28);
        }
        if (holder == null) {
            QualityToolAnnotator.$$$reportNull$$$0(29);
        }
        new OnTheFlyAnnotationAppender(file, new OnTheFlyAnnotationTarget(file.getProject(), holder)).apply(annotationResult);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 7: 
            case 9: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatorInfo";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transfer";
                break;
            }
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageText";
                break;
            }
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blackList";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAnnotatorInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileSuitable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "logWarning";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "toPresentableLocation";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "runTool";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "testTool";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createTempFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileContent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "removeTempFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "showProcessErrorMessage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showProcessErrorMessage$2";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getFileContent$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ContextValidator
    extends PsiRecursiveElementVisitor {
        private boolean myIsValid = true;

        private ContextValidator() {
        }

        public boolean isValid(PsiElement rootElement) {
            if (rootElement == null) {
                return true;
            }
            ApplicationManager.getApplication().runReadAction(() -> this.visitElement(rootElement));
            return this.myIsValid;
        }

        public void visitElement(PsiElement element) {
            if (!this.myIsValid) {
                return;
            }
            if (element instanceof PsiErrorElement) {
                this.myIsValid = false;
                return;
            }
            super.visitElement(element);
        }
    }

    private static class OnTheFlyAnnotationAppender
    extends QualityToolAnnotationAppender {
        OnTheFlyAnnotationAppender(PsiFile file, QualityToolAnnotationAppender.AnnotationTarget holder) {
            super(file, holder);
        }
    }

    protected static class OnTheFlyAnnotationTarget
    implements QualityToolAnnotationAppender.AnnotationTarget {
        private final AnnotationHolder myHolder;
        private final Project myProject;

        public OnTheFlyAnnotationTarget(Project project, AnnotationHolder holder) {
            this.myHolder = holder;
            this.myProject = project;
        }

        @Override
        public void createAnnotation(HighlightDisplayLevel severity, TextRange range, String messageText, IntentionAction ... actions) {
            Annotation annotation;
            if (severity == HighlightDisplayLevel.ERROR) {
                annotation = this.myHolder.createErrorAnnotation(range, messageText);
            } else if (severity == HighlightDisplayLevel.WARNING) {
                annotation = this.myHolder.createWarningAnnotation(range, messageText);
            } else if (severity == HighlightDisplayLevel.WEAK_WARNING) {
                annotation = this.myHolder.createWeakWarningAnnotation(range, messageText);
            } else {
                annotation = this.myHolder.createInfoAnnotation(range, messageText);
                TextAttributes key = SeverityRegistrar.getSeverityRegistrar((Project)this.myProject).getTextAttributesBySeverity(severity.getSeverity());
                if (key == null) {
                    key = SeverityRegistrar.getSeverityRegistrar((Project)this.myProject).getTextAttributesBySeverity(severity.getSeverity());
                }
                if (key != null) {
                    annotation.setEnforcedTextAttributes(key);
                }
            }
            Arrays.stream(actions).forEach(arg_0 -> ((Annotation)annotation).registerFix(arg_0));
            annotation.setNeedsUpdateOnTyping(true);
        }

        @Override
        public void creteInternalErrorAnnotation(@NotNull PsiFile file, @NotNull String messageText, IntentionAction ... quickFix) {
            if (file == null) {
                OnTheFlyAnnotationTarget.$$$reportNull$$$0(0);
            }
            if (messageText == null) {
                OnTheFlyAnnotationTarget.$$$reportNull$$$0(1);
            }
            Annotation annotation = this.myHolder.createWarningAnnotation((PsiElement)file, messageText);
            annotation.setFileLevelAnnotation(true);
            Arrays.stream(quickFix).forEach(arg_0 -> ((Annotation)annotation).registerFix(arg_0));
            annotation.setNeedsUpdateOnTyping(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotator$OnTheFlyAnnotationTarget";
            objectArray[2] = "creteInternalErrorAnnotation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

