/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.automaticRenamers;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FieldAccessorsRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            FieldAccessorsRenamerFactory.$$$reportNull$$$0(0);
        }
        return element instanceof Field && !(element instanceof PhpDocProperty) && !((Field)element).isConstant();
    }

    public String getOptionName() {
        return PhpBundle.message("refactoring.rename.automatic.renamer.accessors.name", new Object[0]);
    }

    public boolean isEnabled() {
        return PhpRefactoringSettings.getInstance().RENAME_FIELD_ACCESSORS;
    }

    public void setEnabled(boolean enabled) {
        PhpRefactoringSettings.getInstance().RENAME_FIELD_ACCESSORS = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        FieldAccessorsRenamer fieldAccessorsRenamer = new FieldAccessorsRenamer((Field)element, newName);
        if (fieldAccessorsRenamer == null) {
            FieldAccessorsRenamerFactory.$$$reportNull$$$0(1);
        }
        return fieldAccessorsRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/automaticRenamers/FieldAccessorsRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/automaticRenamers/FieldAccessorsRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FieldAccessorsRenamer
    extends AutomaticRenamer {
        public FieldAccessorsRenamer(@NotNull Field field, @NotNull String newName) {
            if (field == null) {
                FieldAccessorsRenamer.$$$reportNull$$$0(0);
            }
            if (newName == null) {
                FieldAccessorsRenamer.$$$reportNull$$$0(1);
            }
            PhpClass phpClass = field.getContainingClass();
            if (phpClass == null) {
                return;
            }
            String fieldName = field.getName();
            PhpAccessorsGenerator accessorsGenerator = new PhpAccessorsGenerator(phpClass, field);
            this.myElements.addAll(Arrays.asList(accessorsGenerator.findGetters()));
            Method[] setters = accessorsGenerator.findSetters();
            this.myElements.addAll(Arrays.asList(setters));
            for (Method setter : setters) {
                Parameter[] parameters = setter.getParameters();
                if (parameters.length != 1 || !PhpLangUtil.equalsFieldNames(parameters[0].getName(), fieldName)) continue;
                this.myElements.add(parameters[0]);
            }
            this.suggestAllNames(fieldName, newName);
        }

        public String getDialogTitle() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.field.accessors.dialog.title", new Object[0]);
        }

        public String getDialogDescription() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.field.accessors.dialog.description", new Object[0]);
        }

        public String entityName() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.field.accessors.entity.name", new Object[0]);
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "field";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/rename/automaticRenamers/FieldAccessorsRenamerFactory$FieldAccessorsRenamer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

