/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.navigation;

import com.intellij.lang.Language;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.classAlias.PhpClassAliasIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGotoClassContributor
implements GotoClassContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        ArrayList names = ContainerUtil.newArrayList();
        FileBasedIndex index = FileBasedIndex.getInstance();
        names.addAll(index.getAllKeys(PhpClassNameIndex.KEY, project));
        names.addAll(index.getAllKeys(PhpClassAliasNameIndex.KEY, project));
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(@NonNls String name, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? PhpIndex.getInstance((Project)project).getSearchScope() : GlobalSearchScope.projectScope((Project)project);
        List<PhpClass> items = PhpGotoClassContributor.getClassesByName(name, project, scope);
        NavigationItem[] navigationItemArray = items.size() != 0 ? items.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY) : NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        if (navigationItemArray == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(1);
        }
        return navigationItemArray;
    }

    @NotNull
    public static List<PhpClass> getClassesByName(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(4);
        }
        ArrayList<PhpClass> items = new ArrayList<PhpClass>();
        String lowercasedName = name.toLowerCase();
        items.addAll(StubIndex.getElements(PhpInterfaceIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, PhpClass.class));
        items.addAll(StubIndex.getElements(PhpClassIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, PhpClass.class));
        items.addAll(StubIndex.getElements(PhpTraitIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, PhpClass.class));
        items.addAll(PhpClassAliasIndex.getInstance((Project)project).getAliasesByName(lowercasedName, null, scope));
        ArrayList<PhpClass> arrayList = items;
        if (arrayList == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PhpClass) {
            PhpClass phpClass = (PhpClass)item;
            return phpClass.getFQN();
        }
        return null;
    }

    public String getQualifiedNameSeparator() {
        return "\\";
    }

    @Nullable
    public Language getElementLanguage() {
        return PhpLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/navigation/PhpGotoClassContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/navigation/PhpGotoClassContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

