/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocMarkdownUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocUtil {
    public static final String API_TAG = "@api";
    public static final String AUTHOR_TAG = "@author";
    public static final String CATEGORY_TAG = "@category";
    public static final String COPYRIGHT_TAG = "@copyright";
    public static final String DEPRECATED_TAG = "@deprecated";
    public static final String EXAMPLE_TAG = "@example";
    public static final String FILESOURCE_TAG = "@filesource";
    public static final String GLOBAL_TAG = "@global";
    public static final String IGNORE_TAG = "@ignore";
    public static final String INTERNAL_TAG = "@internal";
    public static final String LICENSE_TAG = "@license";
    public static final String LINK_TAG = "@link";
    public static final String METHOD_TAG = "@method";
    public static final String PACKAGE_TAG = "@package";
    public static final String PARAM_TAG = "@param";
    public static final String PROPERTY_TAG = "@property";
    public static final String PROPERTY_READ_TAG = "@property-read";
    public static final String PROPERTY_WRITE_TAG = "@property-write";
    public static final String RETURN_TAG = "@return";
    public static final String SEE_TAG = "@see";
    public static final String SINCE_TAG = "@since";
    public static final String SUBPACKAGE_TAG = "@subpackage";
    public static final String THROWS_TAG = "@throws";
    public static final String TODO_TAG = "@todo";
    public static final String USES_TAG = "@uses";
    public static final String USED_BY_TAG = "used-by";
    public static final String VAR_TAG = "@var";
    public static final String VERSION_TAG = "@version";
    public static final String INHERITDOC_TAG = "@inheritdoc";
    public static final String MIXIN_TAG = "@mixin";
    public static final String NOINSPECTION = "@noinspection";
    public static final String[] ALL_TAGS = new String[]{"@api", "@author", "@category", "@copyright", "@deprecated", "@example", "@filesource", "@global", "@ignore", "@internal", "@license", "@link", "@method", "@package", "@param", "@property", "@property-read", "@property-write", "@return", "@see", "@since", "@subpackage", "@throws", "@todo", "@uses", "used-by", "@var", "@version", "@inheritdoc", "@mixin"};
    private static final Set<String> ALL_TAGS_MAP = new HashSet<String>();
    private static final TokenSet ALLOWED_PHP_DOC_TOKENS;

    private PhpDocUtil() {
    }

    public static String getTagValue(PsiElement tagElement) {
        StringBuilder valueBuf = new StringBuilder();
        PsiElement lastChild = tagElement.getLastChild();
        if (lastChild != null && PhpPsiUtil.isOfType(lastChild, (IElementType)PhpDocElementTypes.phpDocTagValue)) {
            PhpDocUtil.appendDescription(valueBuf, lastChild);
        }
        for (PsiElement nextElement = tagElement.getNextSibling(); nextElement != null && PhpDocUtil.appendDescription(valueBuf, nextElement); nextElement = nextElement.getNextSibling()) {
        }
        return valueBuf.toString().trim();
    }

    @NotNull
    public static String getDescription(@Nullable PhpDocComment docComment) {
        if (docComment == null) {
            if ("" == null) {
                PhpDocUtil.$$$reportNull$$$0(0);
            }
            return "";
        }
        StringBuilder descBuf = new StringBuilder();
        for (PsiElement child = docComment.getFirstChild(); child != null && PhpDocUtil.appendDescription(descBuf, child); child = child.getNextSibling()) {
        }
        String string = PhpDocMarkdownUtil.markdown2Html(descBuf.toString().trim());
        if (string == null) {
            PhpDocUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean appendDescription(StringBuilder buf, PsiElement element) {
        ASTNode childNode = element.getNode();
        if (childNode == null) {
            return false;
        }
        IElementType currType = childNode.getElementType();
        if (currType == PhpDocTokenTypes.DOC_COMMENT_END || currType == PhpDocElementTypes.phpDocSpecialTag) {
            return false;
        }
        if (element instanceof PhpDocTag) {
            ASTNode prevNode;
            PsiElement prevChild = element.getPrevSibling();
            if (prevChild != null && (prevNode = prevChild.getNode()) != null) {
                if (prevNode.getElementType() != PhpDocTokenTypes.DOC_LBRACE) {
                    return false;
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(PhpDocUtil.processInlineTag(element));
                return true;
            }
        } else if (currType == PhpDocElementTypes.phpDocTagValue) {
            for (PsiElement valueChild = element.getFirstChild(); valueChild != null; valueChild = valueChild.getNextSibling()) {
                PsiElement next;
                boolean atInlineTag = false;
                if (PhpPsiUtil.isOfType(valueChild, PhpDocTokenTypes.DOC_LBRACE) && PhpPsiUtil.isOfType(next = valueChild.getNextSibling(), PhpDocTokenTypes.DOC_TAG_NAME)) {
                    atInlineTag = true;
                    String tagName = next.getText();
                    StringBuilder valueBuf = new StringBuilder();
                    for (next = next.getNextSibling(); next != null && !PhpPsiUtil.isOfType(next, PhpDocTokenTypes.DOC_RBRACE); next = next.getNextSibling()) {
                        valueBuf.append(next.getNode().getChars());
                    }
                    PhpDocUtil.appendInlineTag(buf, tagName, valueBuf.toString().trim());
                    if (next == null) break;
                    valueChild = next;
                }
                if (atInlineTag) continue;
                buf.append(valueChild.getNode().getChars());
            }
            return true;
        }
        if (currType != PhpDocTokenTypes.DOC_LEADING_ASTERISK && currType != PhpDocTokenTypes.DOC_COMMENT_START) {
            int lastEolPos;
            String elementText = element.getText();
            if (childNode.getPsi() instanceof PsiWhiteSpace && childNode.textContains('\n') && (lastEolPos = elementText.lastIndexOf(10)) >= 0) {
                elementText = elementText.substring(0, lastEolPos + 1);
            }
            buf.append(elementText);
        }
        return true;
    }

    private static String processInlineTag(PsiElement tagElement) {
        ASTNode node = tagElement.getNode();
        StringBuilder outBuf = new StringBuilder();
        if (node != null) {
            String tagName = null;
            String tagValue = null;
            StringBuffer textBuf = new StringBuffer();
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() == PhpDocTokenTypes.DOC_TAG_NAME) {
                    tagName = child.getText();
                    continue;
                }
                if (child.getElementType() != PhpDocElementTypes.phpDocTagValue) continue;
                for (ASTNode valueChild = child.getFirstChildNode(); valueChild != null; valueChild = valueChild.getTreeNext()) {
                    IElementType valueType = valueChild.getElementType();
                    if (valueType == PhpDocTokenTypes.DOC_RBRACE) {
                        tagValue = textBuf.toString().trim();
                        textBuf = new StringBuffer();
                        continue;
                    }
                    textBuf.append(valueChild.getText());
                }
            }
            String textAfter = textBuf.toString();
            if (tagName != null && tagValue != null) {
                PhpDocUtil.appendInlineTag(outBuf, tagName, tagValue);
                outBuf.append(textAfter);
                return outBuf.toString();
            }
        }
        return PhpDocUtil.markAsError(tagElement.getText());
    }

    private static void appendInlineTag(@NotNull StringBuilder outBuf, @NotNull String tagName, @NotNull String tagValue) {
        if (outBuf == null) {
            PhpDocUtil.$$$reportNull$$$0(2);
        }
        if (tagName == null) {
            PhpDocUtil.$$$reportNull$$$0(3);
        }
        if (tagValue == null) {
            PhpDocUtil.$$$reportNull$$$0(4);
        }
        if (LINK_TAG.equals(tagName) || SEE_TAG.equals(tagName)) {
            String[] chunks = tagValue.split(" ");
            if (chunks.length > 0) {
                String linkValue = chunks[0].trim();
                String linkDesc = tagValue.replace(linkValue, "").trim();
                outBuf.append("<a href='");
                if (!linkValue.startsWith("http://")) {
                    outBuf.append("psi_element://");
                }
                outBuf.append(linkValue);
                outBuf.append("'>");
                outBuf.append(linkDesc.length() > 0 ? linkDesc : linkValue).append("</a>");
            }
        } else if (INHERITDOC_TAG.equals(tagName)) {
            outBuf.append(tagName);
        }
    }

    private static String markAsError(String text) {
        return "<u color='red'>" + text + "</u>";
    }

    public static String extractDefinition(PhpNamedElement psiElement) {
        ASTNode node;
        StringBuilder buf = new StringBuilder();
        for (PsiElement child = psiElement.getFirstChild(); child != null && ((node = child.getNode()) == null || !PhpElementTypes.ANY_GROUP_STATEMENT.contains(node.getElementType()) && node.getElementType() != PhpTokenTypes.chLBRACE && node.getElementType() != PhpTokenTypes.opCOLON); child = child.getNextSibling()) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.IDENTIFIER)) {
                PhpNamedElementDocSource.appendLink(buf, psiElement.getFQN().replace(".", "::"), psiElement.getNamespaceName());
                continue;
            }
            if (child instanceof ExtendsList || child instanceof ImplementsList) {
                List elements;
                List list = elements = child instanceof ExtendsList ? ((ExtendsList)child).getReferenceElements() : ((ImplementsList)child).getReferenceElements();
                if (elements.isEmpty()) continue;
                buf.append(child instanceof ExtendsList ? "extends " : "implements ");
                for (ClassReference element : elements) {
                    PhpNamedElementDocSource.appendLink(buf, element.getFQN(), element.getNamespaceName());
                    buf.append(", ");
                }
                buf.setLength(buf.length() - 2);
                continue;
            }
            if (child instanceof ParameterList) {
                for (PsiElement parameterListChild = child.getFirstChild(); parameterListChild != null; parameterListChild = parameterListChild.getNextSibling()) {
                    if (parameterListChild instanceof Parameter) {
                        for (PsiElement parameterChild = parameterListChild.getFirstChild(); parameterChild != null; parameterChild = parameterChild.getNextSibling()) {
                            if (parameterChild instanceof ClassReference) {
                                PhpType type = ((ClassReference)parameterChild).getType();
                                String namespaceName = ((Parameter)parameterListChild).getNamespaceName();
                                int lengthBefore = buf.length();
                                PhpNamedElementDocSource.appendType(buf, type, namespaceName, parameterChild.getProject());
                                if (lengthBefore != buf.length()) continue;
                                buf.append(PhpDocUtil.prepareText(parameterChild.getText()));
                                continue;
                            }
                            buf.append(PhpDocUtil.prepareText(parameterChild.getText()));
                        }
                        continue;
                    }
                    buf.append(PhpDocUtil.prepareText(parameterListChild.getText()));
                }
                continue;
            }
            buf.append(PhpDocUtil.prepareText(child.getText()));
        }
        return buf.toString().trim();
    }

    public static String prepareText(String text) {
        String result = text.replace("<code>", "<pre>").replace("</code>", "</pre>").replace("<script", "&lt;script").replace("</script>", "&lt;/script&gt;").replaceAll("\n\\s*\n", "<br>").replaceAll("<([^a-zA-Z/]|$)", "&lt;$1");
        return result;
    }

    @Nullable
    public static String getParamName(@NotNull PhpDocTag docTag, @NotNull Function function) {
        PsiElement nextElement;
        PsiElement tagName;
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(5);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(6);
        }
        if ((tagName = docTag.getFirstChild()) == null || !PARAM_TAG.equals(tagName.getText())) {
            return null;
        }
        for (nextElement = tagName; nextElement != null; nextElement = nextElement.getNextSibling()) {
            String paramName = PhpDocUtil.getParamName(nextElement);
            if (paramName == null) continue;
            return paramName;
        }
        nextElement = docTag.getNextPsiSibling();
        if (nextElement instanceof PsiWhiteSpace) {
            nextElement = nextElement.getNextSibling();
        }
        if (nextElement != null) {
            String candidateName = nextElement.getText();
            for (Parameter parameter : function.getParameters()) {
                if (!candidateName.equals(parameter.getName())) continue;
                return candidateName;
            }
        }
        return null;
    }

    @Nullable
    private static String getParamName(PsiElement element) {
        String text = element.getText();
        if (StringUtil.startsWithChar((CharSequence)text, (char)'$')) {
            text = text.substring(1);
        } else if (text.startsWith("&$")) {
            text = text.substring(2);
        } else if (text.startsWith("...$")) {
            text = text.substring(4);
        } else {
            return null;
        }
        int unlimitedPos = text.indexOf(",...");
        if (unlimitedPos > 0) {
            text = text.substring(0, unlimitedPos);
        }
        return text;
    }

    @NotNull
    public static String[] getRawParamTypeStrings(@NotNull PhpDocTag docTag, @NotNull Function function) {
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(7);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(8);
        }
        PsiElement tagName = docTag.getFirstChild();
        ArrayList<String> typeStrings = new ArrayList<String>();
        if (tagName != null && PARAM_TAG.equals(tagName.getText())) {
            String text;
            String paramName = PhpDocUtil.getParamName(docTag, function);
            PsiElement nextElement = tagName.getNextSibling();
            if (nextElement instanceof PsiWhiteSpace) {
                nextElement = nextElement.getNextSibling();
            }
            if (!(nextElement == null || StringUtil.startsWithChar((CharSequence)(text = nextElement.getText()), (char)'$') || text.startsWith("&$") || paramName != null && paramName.equals(text))) {
                typeStrings.add(text);
                boolean typeExpected = false;
                for (nextElement = nextElement.getNextSibling(); nextElement != null; nextElement = nextElement.getNextSibling()) {
                    IElementType currType = nextElement.getNode().getElementType();
                    if (currType == PhpDocTokenTypes.DOC_PIPE) {
                        typeExpected = true;
                        continue;
                    }
                    if (nextElement instanceof PsiWhiteSpace) continue;
                    if (!typeExpected) break;
                    typeStrings.add(nextElement.getText());
                    typeExpected = false;
                }
            }
        }
        if (typeStrings.isEmpty()) {
            typeStrings.add("mixed");
        }
        String[] stringArray = ArrayUtil.toStringArray(typeStrings);
        if (stringArray == null) {
            PhpDocUtil.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    public static PhpType getParamType(@NotNull PhpDocTag docTag, @NotNull Function function) {
        PhpType docType;
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(10);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(11);
        }
        if (docTag instanceof PhpDocParamTag && docTag.textContains('$') && !(docType = docTag.getType()).isEmpty()) {
            return docType;
        }
        String[] typeStrings = PhpDocUtil.getRawParamTypeStrings(docTag, function);
        PhpType paramType = new PhpType();
        for (String typeString : typeStrings) {
            paramType.add(PhpDocUtil.getTypeString(typeString, (PhpPsiElement)function));
        }
        return paramType;
    }

    public static String getTypeString(@NotNull String text, @NotNull PhpPsiElement element) {
        if (text == null) {
            PhpDocUtil.$$$reportNull$$$0(12);
        }
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(13);
        }
        String typeString = text;
        if ("$this".equals(text)) {
            return text;
        }
        if ("self".equals(text)) {
            return text;
        }
        if ("static".equals(text)) {
            return text;
        }
        if (PhpType.isPrimitiveType((String)typeString) || PhpType.isPluralPrimitiveType((String)typeString)) {
            return StringUtil.startsWithChar((CharSequence)typeString, (char)'\\') ? typeString : "\\" + typeString;
        }
        typeString = PhpReferenceImpl.findNamespaceName(typeString, element);
        return typeString;
    }

    @NotNull
    public static String getParamTagValue(PhpDocTag paramTag, Function function) {
        String prefixedString;
        PsiElement childElement = paramTag.getFirstChild();
        if (childElement == null || !PARAM_TAG.equals(childElement.getText())) {
            if ("" == null) {
                PhpDocUtil.$$$reportNull$$$0(14);
            }
            return "";
        }
        String afterString = PhpDocUtil.getParamName(paramTag, function);
        String string = prefixedString = afterString != null ? "$" + afterString : null;
        if (afterString == null) {
            String[] typeStrings = PhpDocUtil.getRawParamTypeStrings(paramTag, function);
            afterString = typeStrings[typeStrings.length - 1];
        }
        StringBuilder result = new StringBuilder();
        boolean isCollecting = false;
        while (childElement != null) {
            String elementText = childElement.getText();
            if (isCollecting) {
                result.append(elementText);
            }
            if (elementText.equals(afterString) || elementText.equals(prefixedString)) {
                isCollecting = true;
            }
            childElement = childElement.getNextSibling();
        }
        String string2 = result.toString().trim();
        if (string2 == null) {
            PhpDocUtil.$$$reportNull$$$0(15);
        }
        return string2;
    }

    public static boolean isSimpleTag(PsiElement element) {
        IElementType prevType;
        if (!(element instanceof PhpDocTag)) {
            return false;
        }
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if ((prevType = PsiUtilCore.getElementType((PsiElement)prev)) == PhpDocTokenTypes.DOC_LEADING_ASTERISK || prevType == PhpDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
            PsiElement child = element.getFirstChild();
            if (child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TAG_NAME)) {
                if (ALL_TAGS_MAP.contains(child.getText())) {
                    return true;
                }
                if ((child = PhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true)) == null) {
                    return true;
                }
                IElementType childType = child.getNode().getElementType();
                if (childType == PhpDocElementTypes.phpDocType || childType == PhpDocElementTypes.phpDocVariable || childType == PhpDocElementTypes.phpDocRef) {
                    return true;
                }
                if (childType == PhpDocElementTypes.phpDocTagValue && ((child = child.getFirstChild()) == null || PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER) || PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TEXT))) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInsidePhpDocAttributeList(@NotNull PsiElement element) {
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(16);
        }
        for (PsiElement parent = element.getParent(); parent != null && !(parent instanceof PsiFile) && !(parent instanceof PhpDocComment); parent = parent.getParent()) {
            if (!PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocAttributeList)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDocVarType(@Nullable String tagName) {
        return VAR_TAG.equals(tagName) || GLOBAL_TAG.equals(tagName) || "@type".equals(tagName);
    }

    public static String getTypePresentation(@NotNull Project project, @NotNull PhpType phpType, @Nullable PhpPsiElement scope) {
        String typePresentation;
        if (project == null) {
            PhpDocUtil.$$$reportNull$$$0(17);
        }
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(18);
        }
        PhpType globalType = phpType.global(project);
        String string = typePresentation = scope != null && !((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)scope.getContainingFile(), PhpCodeStyleSettings.class)).PHPDOC_USE_FQCN ? PhpCodeInsightUtil.toQualifiedPresentation(globalType, scope) : globalType.toStringResolved();
        if (scope != null && globalType.size() > 1 && PhpType.intersects((PhpType)globalType, (PhpType)PhpType.NULL)) {
            return PhpDocUtil.reorderNullTypeIfNeeded(typePresentation, (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)scope.getContainingFile(), PhpCodeStyleSettings.class));
        }
        return typePresentation;
    }

    private static String reorderNullTypeIfNeeded(String typePresentation, PhpCodeStyleSettings settings) {
        if (settings.NULL_TYPE_POSITION != PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE) {
            List split = StringUtil.split((String)typePresentation, (String)"|");
            String nullType = split.contains("null") ? "null" : StringUtil.toUpperCase((String)"null");
            split.remove(nullType);
            String notNullTypes = StringUtil.join((Collection)split, (String)"|");
            return settings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING ? StringUtil.join((String[])new String[]{nullType, "|", notNullTypes}) : StringUtil.join((String[])new String[]{notNullTypes, "|", nullType});
        }
        return typePresentation;
    }

    public static PhpType getReturnType(@NotNull Function function) {
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(19);
        }
        return PhpDocUtil.getDeclaredOrInferredType((PhpTypedElement)function);
    }

    public static PhpType getParameterType(@NotNull Parameter parameter) {
        if (parameter == null) {
            PhpDocUtil.$$$reportNull$$$0(20);
        }
        return PhpDocUtil.getDeclaredOrInferredType((PhpTypedElement)parameter);
    }

    private static PhpType getDeclaredOrInferredType(@NotNull PhpTypedElement e) {
        PhpType declaredType;
        if (e == null) {
            PhpDocUtil.$$$reportNull$$$0(21);
        }
        if (!(declaredType = e.getDeclaredType()).isEmpty()) {
            return declaredType;
        }
        return e.getInferredType().globalLocationAware((PsiElement)e);
    }

    @NotNull
    public static List<PhpDocTag> collectTagsConsideringInheritance(@NotNull Function function, @NotNull String tagName) {
        List tags;
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(22);
        }
        if (tagName == null) {
            PhpDocUtil.$$$reportNull$$$0(23);
        }
        if (PhpDocUtil.processFunction(function, tagName, tags = ContainerUtil.newSmartList()) && function instanceof Method) {
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)((Method)function), (classMember, subClass, baseClass) -> {
                if (tagName == null) {
                    PhpDocUtil.$$$reportNull$$$0(29);
                }
                return PhpDocUtil.processFunction((Function)((Method)classMember), tagName, tags);
            });
        }
        List list = tags;
        if (list == null) {
            PhpDocUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static boolean processFunction(@NotNull Function function, @NotNull String name, @NotNull List<PhpDocTag> tags) {
        PhpDocComment comment;
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(25);
        }
        if (name == null) {
            PhpDocUtil.$$$reportNull$$$0(26);
        }
        if (tags == null) {
            PhpDocUtil.$$$reportNull$$$0(27);
        }
        if (!(function instanceof PhpDocMethod) && (comment = function.getDocComment()) != null) {
            tags.addAll(Arrays.asList(comment.getTagElementsByName(name)));
            if (!comment.hasInheritDocTag()) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasOnlyNoInspectionTag(@NotNull PhpDocComment comment) {
        List tags;
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(28);
        }
        if ((tags = PhpPsiUtil.getChildren((PsiElement)comment, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF)).size() != 1) {
            return false;
        }
        PhpDocTag tag = (PhpDocTag)ContainerUtil.getFirstItem(tags);
        if (tag == null || !NOINSPECTION.equals(tag.getName())) {
            return false;
        }
        for (PsiElement child = comment.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiWhiteSpace || child instanceof PhpDocTag || PhpPsiUtil.isOfType(child, ALLOWED_PHP_DOC_TOKENS)) continue;
            return false;
        }
        return true;
    }

    static {
        Collections.addAll(ALL_TAGS_MAP, ALL_TAGS);
        ALLOWED_PHP_DOC_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpDocTokenTypes.DOC_COMMENT_START, PhpDocTokenTypes.DOC_LEADING_ASTERISK, PhpDocTokenTypes.DOC_COMMENT_END});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outBuf";
                break;
            }
            case 3: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagValue";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawParamTypeStrings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTagValue";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTagsConsideringInheritance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendInlineTag";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParamName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRawParamTypeStrings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParamType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePhpDocAttributeList";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypePresentation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredOrInferredType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectTagsConsideringInheritance";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyNoInspectionTag";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectTagsConsideringInheritance$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

