/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.addDependency;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.composer.addDependency.ComposerPackagistUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDependencyForm {
    public static final String DEFAULT_VERSION = PhpBundle.message("framework.composer.package.default.version", new Object[0]);
    private JBList<String> myPackageNamesList;
    private JComboBox<String> myVersionComboBox;
    private JPanel myMainPanel;
    private PackageNamesModel myPackageNamesModel;
    private FilterComponent myFilterComponent;
    private JBLabel myFilterLabel;
    private JBLabel myWarningLabel;
    private JPanel myVersionPanel;
    private JBLabel myInstalledVersionLabel;
    private JPanel myAvailablePackagesPanel;
    private final boolean myShowDefaultVersion;
    private final Map<String, ComposerPackage> myPackagesCache;
    private final Map<String, InstalledPackageData> myInstalledPackages;
    private final PackageNamesComparator myComparator;

    public AddDependencyForm(boolean showSearchLabel, boolean showDefaultVersion, final @Nullable Runnable validationChangesListener, boolean minimize) {
        this.$$$setupUI$$$();
        this.myPackagesCache = new HashMap<String, ComposerPackage>();
        this.myInstalledPackages = new HashMap<String, InstalledPackageData>();
        this.myComparator = new PackageNamesComparator();
        this.myShowDefaultVersion = showDefaultVersion;
        this.myVersionComboBox.setEnabled(false);
        this.myFilterLabel.setLabelFor((Component)this.myFilterComponent);
        this.myFilterLabel.setVisible(showSearchLabel);
        if (validationChangesListener != null) {
            this.myPackageNamesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    validationChangesListener.run();
                }
            });
            this.myVersionComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    validationChangesListener.run();
                }
            });
        }
        this.myPackageNamesList.setCellRenderer((ListCellRenderer)new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                if (value != null && AddDependencyForm.this.myInstalledPackages.containsKey(value)) {
                    this.setIcon(AllIcons.Actions.Checked_small);
                }
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(this::initModelWithReloadedPackages);
        this.myPackageNamesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                String packageName = (String)AddDependencyForm.this.myPackageNamesList.getSelectedValue();
                AddDependencyForm.this.myVersionComboBox.setEnabled(packageName != null);
                AddDependencyForm.this.myVersionComboBox.removeAllItems();
                if (packageName == null) {
                    return;
                }
                ComposerPackage aPackage = (ComposerPackage)AddDependencyForm.this.myPackagesCache.get(packageName.toLowerCase(Locale.ENGLISH));
                if (aPackage != null) {
                    AddDependencyForm.this.applyPackageDataToUiIfCorresponds(aPackage);
                    return;
                }
                AddDependencyForm.this.setLoadingStatus(true);
                ApplicationManager.getApplication().executeOnPooledThread(() -> AddDependencyForm.this.loadPackageDataAndApplyToUi(packageName));
            }
        });
        this.myWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myWarningLabel.setVisible(false);
        if (minimize) {
            this.myAvailablePackagesPanel.setBorder(null);
            this.myPackageNamesList.setVisibleRowCount(6);
        }
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myMainPanel);
    }

    private void loadPackageDataAndApplyToUi(String packageName) {
        ComposerPackage aPackage = null;
        String errorMessage = null;
        try {
            aPackage = ComposerPackagistUtil.getPackage(packageName);
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        ComposerPackage finalAPackage = aPackage;
        String finalErrorMessage = errorMessage;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalAPackage != null) {
                this.myPackagesCache.put(finalAPackage.getName().toLowerCase(Locale.ENGLISH), finalAPackage);
                this.applyPackageDataToUiIfCorresponds(finalAPackage);
                return;
            }
            this.setWarning(finalErrorMessage);
            this.setLoadingStatus(false);
        }, ModalityState.any());
    }

    private void setWarning(String text) {
        this.myWarningLabel.setText(text);
        this.myWarningLabel.setVisible(!StringUtil.isEmpty((String)text));
    }

    private void applyPackageDataToUiIfCorresponds(ComposerPackage aPackage) {
        String value = (String)this.myPackageNamesList.getSelectedValue();
        if (!aPackage.getName().equalsIgnoreCase(value)) {
            return;
        }
        this.setLoadingStatus(false);
        InstalledPackageData installedData = this.myInstalledPackages.get(aPackage.getName());
        this.myVersionComboBox.removeAllItems();
        if (installedData != null) {
            this.myInstalledVersionLabel.setText(installedData.getVersion());
            CardLayout layout = (CardLayout)this.myVersionPanel.getLayout();
            layout.show(this.myVersionPanel, "update");
        } else {
            List<String> versions = aPackage.getVersions();
            if (this.myShowDefaultVersion) {
                this.myVersionComboBox.addItem(DEFAULT_VERSION);
            }
            Collections.sort(versions, ComposerPackage.VERSIONS_COMPARATOR);
            for (String s : versions) {
                this.myVersionComboBox.addItem(s);
            }
            CardLayout layout = (CardLayout)this.myVersionPanel.getLayout();
            layout.show(this.myVersionPanel, "install");
        }
        this.setWarning(null);
    }

    private void createUIComponents() {
        this.myFilterComponent = new MyPackageFilter();
    }

    private void setLoadingStatus(boolean status) {
        this.myPackageNamesList.setPaintBusy(status);
    }

    private void initModelWithReloadedPackages() {
        this.setLoadingStatus(true);
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            String exceptionMessage = null;
            try {
                List<String> packageNames = ComposerPackagistUtil.getPackageNames();
                Collections.sort(packageNames, this.myComparator);
                this.myPackageNamesModel = new PackageNamesModel(packageNames);
            }
            catch (IOException e) {
                exceptionMessage = e.getMessage();
            }
            finally {
                String finalExceptionMessage = exceptionMessage;
                application.invokeLater(() -> {
                    if (this.myPackageNamesModel != null) {
                        this.myPackageNamesList.setModel((ListModel)((Object)this.myPackageNamesModel));
                        this.setWarning(null);
                    } else if (finalExceptionMessage != null) {
                        String text = PhpBundle.message("frameworks.composer.could.not.get.packages.info.0", finalExceptionMessage);
                        this.setWarning(text);
                    }
                    this.setLoadingStatus(false);
                }, ModalityState.any());
            }
        });
    }

    protected void showOutput(String output, @NotNull String message, Project project) {
        if (message == null) {
            AddDependencyForm.$$$reportNull$$$0(0);
        }
        ComposerUtils.createOutputPopup(output, message, "", project).showInCenterOf((Component)this.myMainPanel);
    }

    JComboBox getVersionComboBox() {
        return this.myVersionComboBox;
    }

    public ValidationInfo validate() {
        Object value = this.myPackageNamesList.getSelectedValue();
        if (value == null) {
            return new ValidationInfo(PhpBundle.message("framework.composer.add.dependency.no.package.selected", new Object[0]), this.myPackageNamesList);
        }
        Object version = this.myVersionComboBox.getSelectedItem();
        if (!(version instanceof String) && !this.isSelectedPackageInstalled()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.add.dependency.no.version.selected", new Object[0]), this.myVersionComboBox);
        }
        return null;
    }

    @Nullable
    public ComposerPackage getSelectedPackage() {
        String value = (String)this.myPackageNamesList.getSelectedValue();
        if (value == null) {
            return null;
        }
        return this.myPackagesCache.get(value.toLowerCase(Locale.ENGLISH));
    }

    @Nullable
    public String getVersion() {
        Object value = this.myVersionComboBox.getSelectedItem();
        if (!(value instanceof String)) {
            return null;
        }
        if (this.myShowDefaultVersion && DEFAULT_VERSION.equals(value)) {
            return null;
        }
        return (String)value;
    }

    public boolean isSelectedPackageInstalled() {
        String value = (String)this.myPackageNamesList.getSelectedValue();
        if (value == null) {
            return false;
        }
        return this.myInstalledPackages.containsKey(value);
    }

    public void addInstalledPackage(String name, String version) {
        InstalledPackageData data = new InstalledPackageData(name, version);
        this.myInstalledPackages.put(data.getName(), data);
    }

    public void removeInstalledPackage(String name) {
        this.myInstalledPackages.remove(name);
    }

    public void refreshPackagesList(boolean scrollToSelection) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myPackageNamesList.updateUI();
            String selectedValue = (String)this.myPackageNamesList.getSelectedValue();
            this.myPackageNamesModel.sort();
            this.myPackageNamesList.clearSelection();
            this.myPackageNamesList.setSelectedValue((Object)selectedValue, scrollToSelection);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/composer/addDependency/AddDependencyForm", "showOutput"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JBList jBList;
        JPanel jPanel2;
        JBLabel jBLabel3;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.setMinimumSize(new Dimension(476, 160));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "North");
        this.myFilterLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Filter packages:");
        jBLabel3.setDisplayedMnemonic('F');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        FilterComponent filterComponent = this.myFilterComponent;
        jPanel5.add((Component)filterComponent, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, "Center");
        this.myAvailablePackagesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("framework.composer.add.dependency.available.packages.label"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(250, 100), null, null));
        this.myPackageNamesList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        this.myVersionPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, "install");
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/PhpBundle").getString("framework.composer.label.version.to.install"));
        jPanel7.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myVersionComboBox = jComboBox;
        jPanel7.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, "update");
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/PhpBundle").getString("framework.composer.label.installed.version"));
        jPanel8.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInstalledVersionLabel = jBLabel2 = new JBLabel();
        jPanel8.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWarningLabel = jBLabel = new JBLabel();
        jPanel3.add((Component)jBLabel, "South");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class PackageNamesComparator
    implements Comparator<String> {
        private PackageNamesComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            boolean installed2;
            boolean installed1 = AddDependencyForm.this.myInstalledPackages.containsKey(o1);
            if (installed1 != (installed2 = AddDependencyForm.this.myInstalledPackages.containsKey(o2))) {
                return installed1 ? -1 : 1;
            }
            return StringUtil.compare((String)o1, (String)o2, (boolean)true);
        }
    }

    private class PackageNamesModel
    extends CollectionListModel<String> {
        protected final List<String> myFilteredOut;
        protected final List<String> myVisible;

        private PackageNamesModel(List<String> packageNames) {
            super(packageNames);
            this.myFilteredOut = new ArrayList<String>();
            this.myVisible = packageNames;
        }

        private void filter(String filter) {
            List<String> toProcess = this.toProcess();
            toProcess.addAll(this.myFilteredOut);
            this.myFilteredOut.clear();
            ArrayList<String> filtered = new ArrayList<String>();
            for (String aPackage : toProcess) {
                if (StringUtil.containsIgnoreCase((String)aPackage, (String)filter)) {
                    filtered.add(aPackage);
                    continue;
                }
                this.myFilteredOut.add(aPackage);
            }
            this.filter(filtered);
        }

        private void filter(List<String> filtered) {
            this.myVisible.clear();
            AddDependencyForm.this.myPackageNamesList.clearSelection();
            this.myVisible.addAll(filtered);
            this.sort();
        }

        void sort() {
            Collections.sort(this.myVisible, AddDependencyForm.this.myComparator);
            this.fireContentsChanged((Object)this, 0, this.myVisible.size());
        }

        public String getElementAt(int index) {
            return this.myVisible.get(index);
        }

        private List<String> toProcess() {
            return new ArrayList<String>(this.myVisible);
        }

        public int getSize() {
            return this.myVisible.size();
        }
    }

    private class MyPackageFilter
    extends FilterComponent {
        private MyPackageFilter() {
            super("COMPOSER_PACKAGE_FILTER", 5);
        }

        public void filter() {
            if (AddDependencyForm.this.myPackageNamesModel != null) {
                AddDependencyForm.this.myPackageNamesModel.filter(this.getFilter());
            }
        }
    }
}

