/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class TagToAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField attributeNameField;
    private final XmlTag tag;

    TagToAttributeDialog(XmlTag tag) {
        super(tag.getProject(), true);
        String tagName = tag.getName();
        this.tag = tag;
        XmlTag parentTag = tag.getParentTag();
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Replace Tag With Attribute");
        this.attributeNameLabel.setText("Name for new attribute");
        XmlAttribute[] attributes = parentTag.getAttributes();
        String attributeName = null;
        for (XmlAttribute attribute : attributes) {
            if (attribute == null) continue;
            attributeName = attribute.getLocalName();
            break;
        }
        String newAttributeName = XMLUtil.attributeNameFromTag(tagName, attributeName);
        this.attributeNameField = new JTextField(newAttributeName);
        Document document = this.attributeNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.TagToAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.attributeNameField;
    }

    public String getAttributeName() {
        return this.attributeNameField.getText().trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Replace tag " + tagName + " with attribute"), (boolean)true);
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.attributeNameField.setEditable(true);
        box.add(this.attributeNameField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String attributeName = this.getAttributeName();
        boolean attributeNameEntered = XMLUtil.attributeNameIsValid(attributeName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return attributeNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String parentTagName = this.tag.getParentTag().getName();
        String tagName = this.tag.getName();
        String attributeName = this.getAttributeName();
        return " <xsl:template match=\"" + parentTagName + "\">\n\t<xsl:copy> \n\t\t<xsl:for-each select =\"child::" + tagName + "\">\n\t\t\t<xsl:attribute name = \"" + attributeName + "\">\n\t\t\t\t<xsl:value-of select=\".\"/>\n\t\t\t</xsl:attribute>\n\t\t</xsl:for-each>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>\n<xsl:template match=\"" + parentTagName + "/" + tagName + "\"/>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        if ("refactoring.tagToAttribute" == null) {
            TagToAttributeDialog.$$$reportNull$$$0(0);
        }
        return "refactoring.tagToAttribute";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/tagtoattribute/TagToAttributeDialog", "getHelpId"));
    }
}

