/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebStormDiagramsConfigurator
implements StartupActivity,
DumbAware {
    public static final String SHOW_UML_DIAGRAM = "ShowUmlDiagram";
    public static final String UML_GROUP_SIMPLE = "UML.Group.Simple";
    public static final String UML_GROUP = "UML.Group";
    public static final String SHOW_UML_DIAGRAM_POPUP = "ShowUmlDiagramPopup";
    @NonNls
    private static final Set<String> KEEP = ContainerUtil.set((Object[])new String[]{"ShowUmlDiagram", "UML.Group", "UML.Group.Simple", "ShowUmlDiagramPopup"});
    @NonNls
    private static final String[] REMOVE_ACTIONS = new String[]{"UML.Group.Simple", "UML.Group", "Uml.NewGroup", "Uml.ShowDiff", "ShowUmlDiagram", "ShowUmlDiagramPopup", "UML.ShowChanges"};
    private static volatile boolean ourWorkDone;

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            WebStormDiagramsConfigurator.$$$reportNull$$$0(0);
        }
        if (!PlatformUtils.isWebStorm() || ourWorkDone) {
            return;
        }
        WebStormDiagramsConfigurator.removeDiagramActions(ActionManager.getInstance());
        ourWorkDone = true;
    }

    private static void removeDiagramActions(ActionManager actionManager) {
        DiagramProvider[] extensions;
        AbbreviationManager abbreviationManager = AbbreviationManager.getInstance();
        for (String actionId : REMOVE_ACTIONS) {
            if (KEEP.contains(actionId)) continue;
            Set abbreviations = abbreviationManager.getAbbreviations(actionId);
            for (String abbreviation : abbreviations) {
                abbreviationManager.remove(abbreviation, actionId);
            }
        }
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, "VcsHistoryActionsGroup", "Uml.ShowDiff");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, "VcsGlobalGroup", "UML.ShowChanges");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, "ChangesViewPopupMenu", "UML.ShowChanges");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, "UML.EditorGroup", "UML.ShowChanges");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, UML_GROUP, "UML.ShowChanges");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, UML_GROUP_SIMPLE, "UML.ShowChanges");
        for (String actionId : REMOVE_ACTIONS) {
            ActionGroup group;
            AnAction action;
            if (KEEP.contains(actionId) || (action = actionManager.getAction(actionId)) == null) continue;
            if (actionManager.isGroup(actionId) && (group = (ActionGroup)action) instanceof DefaultActionGroup) {
                ((DefaultActionGroup)group).removeAll();
            }
            actionManager.unregisterAction(actionId);
        }
        for (DiagramProvider extension : extensions = (DiagramProvider[])DiagramProvider.DIAGRAM_PROVIDER.getExtensions()) {
            if (!"DiffUmlProvider".equals(extension.getClass().getSimpleName())) continue;
            Extensions.getRootArea().getExtensionPoint(DiagramProvider.DIAGRAM_PROVIDER).unregisterExtension((Object)extension);
        }
    }

    private static void removeFromGroup(@NotNull ActionManager actionManager, @NotNull String groupId, @NotNull String actionId) {
        AnAction action;
        if (actionManager == null) {
            WebStormDiagramsConfigurator.$$$reportNull$$$0(1);
        }
        if (groupId == null) {
            WebStormDiagramsConfigurator.$$$reportNull$$$0(2);
        }
        if (actionId == null) {
            WebStormDiagramsConfigurator.$$$reportNull$$$0(3);
        }
        if ((action = actionManager.getAction(actionId)) == null) {
            return;
        }
        DefaultActionGroup changesViewToolbar = (DefaultActionGroup)actionManager.getAction(groupId);
        changesViewToolbar.getChildren(null);
        changesViewToolbar.remove(action);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/WebStormDiagramsConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeFromGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

