<?php

/**
 * BaseLocation
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                             $id                                    Type: integer(13), primary key
 * @property string                          $name                                  Type: string(110)
 * @property string                          $countryCode                           Type: string(3)
 * @property string                          $province                              Type: string(60)
 * @property string                          $city                                  Type: string(60)
 * @property string                          $address                               Type: string(255)
 * @property string                          $zipCode                               Type: string(35)
 * @property string                          $phone                                 Type: string(35)
 * @property string                          $fax                                   Type: string(35)
 * @property string                          $notes                                 Type: string(255)
 * @property Country                         $country                               
 * @property Doctrine_Collection|Employee[]  $employees                             
 *  
 * @method int                               getId()                                Type: integer(13), primary key
 * @method string                            getName()                              Type: string(110)
 * @method string                            getCountrycode()                       Type: string(3)
 * @method string                            getProvince()                          Type: string(60)
 * @method string                            getCity()                              Type: string(60)
 * @method string                            getAddress()                           Type: string(255)
 * @method string                            getZipcode()                           Type: string(35)
 * @method string                            getPhone()                             Type: string(35)
 * @method string                            getFax()                               Type: string(35)
 * @method string                            getNotes()                             Type: string(255)
 * @method Country                           getCountry()                           
 * @method Doctrine_Collection|Employee[]    getEmployees()                         
 *  
 * @method Location                          setId(int $val)                        Type: integer(13), primary key
 * @method Location                          setName(string $val)                   Type: string(110)
 * @method Location                          setCountrycode(string $val)            Type: string(3)
 * @method Location                          setProvince(string $val)               Type: string(60)
 * @method Location                          setCity(string $val)                   Type: string(60)
 * @method Location                          setAddress(string $val)                Type: string(255)
 * @method Location                          setZipcode(string $val)                Type: string(35)
 * @method Location                          setPhone(string $val)                  Type: string(35)
 * @method Location                          setFax(string $val)                    Type: string(35)
 * @method Location                          setNotes(string $val)                  Type: string(255)
 * @method Location                          setCountry(Country $val)               
 * @method Location                          setEmployees(Doctrine_Collection $val) 
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLocation extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_location');
        $this->hasColumn('id', 'integer', 13, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 13,
             ));
        $this->hasColumn('name', 'string', 110, array(
             'type' => 'string',
             'length' => 110,
             ));
        $this->hasColumn('country_code as countryCode', 'string', 3, array(
             'type' => 'string',
             'length' => 3,
             ));
        $this->hasColumn('province', 'string', 60, array(
             'type' => 'string',
             'length' => 60,
             ));
        $this->hasColumn('city', 'string', 60, array(
             'type' => 'string',
             'length' => 60,
             ));
        $this->hasColumn('address', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('zip_code as zipCode', 'string', 35, array(
             'type' => 'string',
             'length' => 35,
             ));
        $this->hasColumn('phone', 'string', 35, array(
             'type' => 'string',
             'length' => 35,
             ));
        $this->hasColumn('fax', 'string', 35, array(
             'type' => 'string',
             'length' => 35,
             ));
        $this->hasColumn('notes', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Country as country', array(
             'local' => 'country_code',
             'foreign' => 'cou_code'));

        $this->hasMany('Employee as employees', array(
             'refClass' => 'EmpLocations',
             'local' => 'location_id',
             'foreign' => 'emp_number'));
    }
}