/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Info {
    private static final Properties properties = new Properties();
    private static final String VERSION;
    private static final String REVISION;

    public static String getVersion() {
        return VERSION;
    }

    public static String getFullVersion() {
        return "OpenGrok v" + VERSION + " rev " + REVISION;
    }

    public static String getRevision() {
        return REVISION;
    }

    private Info() {
    }

    static {
        try (InputStream in = Info.class.getResourceAsStream("info.properties");){
            if (in != null) {
                properties.load(in);
            }
            VERSION = properties.getProperty("version", "unknown");
            REVISION = properties.getProperty("changeset", "unknown");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

