/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import net.claribole.zvtm.glyphs.projection.ProjText;

public class VText
extends Glyph {
    public static final short TEXT_ANCHOR_START = 0;
    public static final short TEXT_ANCHOR_MIDDLE = 1;
    public static final short TEXT_ANCHOR_END = 2;
    public short text_anchor = 0;
    public AffineTransform at;
    public ProjText[] pc;
    public boolean zoomSensitive = true;
    public static float fontSize = VirtualSpaceManager.getMainFont().getSize2D();
    public Font font;
    public Rectangle2D bounds;
    public String text;
    public float scaleFactor = 1.0f;
    public float trueCoef = 1.0f;

    public VText(String t) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.text = t;
        this.setColor(Color.white);
    }

    public VText(long x, long y, int z, Color c, String t) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.text = t;
        this.setColor(c);
    }

    public VText(long x, long y, int z, Color c, String t, short ta) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.text = t;
        this.setColor(c);
        this.text_anchor = ta;
    }

    public VText(long x, long y, int z, Color c, String t, short ta, float scale) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.text = t;
        this.setColor(c);
        this.text_anchor = ta;
        this.scaleFactor = scale;
    }

    public void initCams(int nbCam) {
        this.pc = new ProjText[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjText();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjText[] ta = this.pc;
                this.pc = new ProjText[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjText();
            } else {
                System.err.println("VText:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjText[1];
            this.pc[0] = new ProjText();
        } else {
            System.err.println("VText:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    public void sizeTo(float factor) {
    }

    public void reSize(float factor) {
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return 1.0f;
    }

    public float getOrient() {
        return this.orient;
    }

    public void setZoomSensitive(boolean b) {
        if (this.zoomSensitive != b) {
            this.zoomSensitive = b;
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean isZoomSensitive() {
        return this.zoomSensitive;
    }

    public boolean visibleInRegion(long wb, long nb, long eb, long sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        if (this.text_anchor == 0) {
            return this.vx <= eb && this.vx + (long)this.pc[i].cw >= wb && this.vy <= nb && this.vy + (long)this.pc[i].ch >= sb;
        }
        if (this.text_anchor == 1) {
            return this.vx - (long)(this.pc[i].cw / 2) <= eb && this.vx + (long)(this.pc[i].cw / 2) >= wb && this.vy <= nb && this.vy + (long)this.pc[i].ch >= sb;
        }
        return this.vx - (long)this.pc[i].cw <= eb && this.vx >= wb && this.vy <= nb && this.vy + (long)this.pc[i].ch >= sb;
    }

    public boolean containedInRegion(long wb, long nb, long eb, long sb, int i) {
        return this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb && (this.text_anchor == 0 ? this.vx <= eb && this.vx + (long)this.pc[i].cw >= wb && this.vy <= nb && this.vy - (long)this.pc[i].ch >= sb : (this.text_anchor == 1 ? this.vx + (long)(this.pc[i].cw / 2) <= eb && this.vx - (long)(this.pc[i].cw / 2) >= wb && this.vy <= nb && this.vy - (long)this.pc[i].ch >= sb : this.vx + (long)this.pc[i].cw <= eb && this.vx >= wb && this.vy <= nb && this.vy - (long)this.pc[i].ch >= sb));
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        boolean res = false;
        switch (this.text_anchor) {
            case 0: {
                if (cvx < this.vx || cvy < this.vy || cvx > this.vx + (long)this.pc[camIndex].cw || cvy > this.vy + (long)this.pc[camIndex].ch) break;
                res = true;
                break;
            }
            case 1: {
                if (cvx < this.vx - (long)(this.pc[camIndex].cw / 2) || cvy < this.vy || cvx > this.vx + (long)(this.pc[camIndex].cw / 2) || cvy > this.vy + (long)this.pc[camIndex].ch) break;
                res = true;
                break;
            }
            default: {
                if (cvx > this.vx || cvy < this.vy || cvx < this.vx - (long)this.pc[camIndex].cw || cvy > this.vy + (long)this.pc[camIndex].ch) break;
                res = true;
            }
        }
        return res;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        if (this.text_anchor == 0) {
            return dvs.intersects(this.vx, this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
        }
        if (this.text_anchor == 1) {
            return dvs.intersects(this.vx - (long)(this.pc[camIndex].cw / 2), this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
        }
        return dvs.intersects(this.vx - (long)this.pc[camIndex].cw, this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        this.trueCoef = this.scaleFactor * this.coef;
        if (this.trueCoef * fontSize > this.vsm.getTextDisplayedAsSegCoef() || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VirtualSpaceManager.getMainFont());
            if (!this.pc[i].valid) {
                this.bounds = g.getFontMetrics().getStringBounds(this.text, g);
                this.pc[i].cw = (int)Math.round(this.bounds.getWidth() * (double)this.scaleFactor);
                this.pc[i].ch = (int)Math.round(this.bounds.getHeight() * (double)this.scaleFactor);
                this.pc[i].valid = true;
            }
            this.at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((float)(dx + this.pc[i].cx) - (float)this.pc[i].cw * this.coef / 2.0f, dy + this.pc[i].cy) : AffineTransform.getTranslateInstance((float)(dx + this.pc[i].cx) - (float)this.pc[i].cw * this.coef, dy + this.pc[i].cy));
            if (this.zoomSensitive) {
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
            }
            g.setTransform(this.at);
            g.drawString(this.text, 0.0f, 0.0f);
            g.setTransform(stdT);
        } else {
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        this.trueCoef = this.scaleFactor * this.coef;
        if (this.trueCoef * fontSize > this.vsm.getTextDisplayedAsSegCoef() || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VirtualSpaceManager.getMainFont());
            if (!this.pc[i].lvalid) {
                this.bounds = g.getFontMetrics().getStringBounds(this.text, g);
                this.pc[i].lcw = (int)Math.round(this.bounds.getWidth() * (double)this.scaleFactor);
                this.pc[i].lch = (int)Math.round(this.bounds.getHeight() * (double)this.scaleFactor);
                this.pc[i].lvalid = true;
            }
            this.at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((float)(dx + this.pc[i].lcx) - (float)this.pc[i].lcw * this.coef / 2.0f, dy + this.pc[i].lcy) : AffineTransform.getTranslateInstance((float)(dx + this.pc[i].lcx) - (float)this.pc[i].lcw * this.coef, dy + this.pc[i].lcy));
            if (this.zoomSensitive) {
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
            }
            g.setTransform(this.at);
            g.drawString(this.text, 0.0f, 0.0f);
            g.setTransform(stdT);
        } else {
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public void setText(String t) {
        this.text = t;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.invalidate();
    }

    public void setScale(float s) {
        this.scaleFactor = s;
        this.invalidate();
    }

    public float getScale() {
        return this.scaleFactor;
    }

    public void invalidate() {
        try {
            for (int i = 0; i < this.pc.length; ++i) {
                this.pc[i].valid = false;
                this.pc[i].lvalid = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public LongPoint getBounds(int i) {
        return new LongPoint(this.pc[i].cw, this.pc[i].ch);
    }

    public boolean validBounds(int i) {
        return this.pc[i].valid;
    }

    public void setSpecialFont(Font f) {
        if (f != null) {
            this.font = f;
            fontSize = this.font.getSize2D();
        } else {
            this.font = null;
            fontSize = VirtualSpaceManager.getMainFont().getSize2D();
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.invalidate();
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        return VirtualSpaceManager.getMainFont();
    }

    public boolean usesSpecialFont() {
        return this.font != null;
    }

    public String getText() {
        return this.text;
    }

    public void setTextAnchor(short ta) {
        this.text_anchor = ta;
    }

    public short getTextAnchor() {
        return this.text_anchor;
    }

    public Object clone() {
        VText res = new VText(this.vx, this.vy, 0, this.color, this.text, this.text_anchor);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }

    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.mouseInsideColor != null) {
                this.color = this.mouseInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.color = selectedColor;
            update = true;
        } else if (this.mouseInsideColor != null) {
            this.color = this.fColor;
            update = true;
        }
        if (update) {
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
        }
    }
}

