local fmt = require "format"

-- For translation, just transliterate if necessary.
local articles = {
   _("Das"),
   _("Der"),
   _("Kono"),
   _("La"),
   _("Le"),
   _("The"),
   _("Ye"),
}
local descriptors = {
   _("Aerobic"),
   _("Aku No"),
   _("Amai"),
   _("Ancient"),
   _("Astro"),
   _("Baggy"),
   _("Bakana"),
   _("Bald"),
   _("Beautiful"),
   p_("name", "Benevolent"),
   _("Bedrohliche"),
   _("Big"),
   _("Big Bad"),
   _("Bloody"),
   _("Bright"),
   _("Brooding"),
   _("BT"),
   _("Bureina"),
   _("Caped"),
   _("Citrus"),
   _("Clustered"),
   _("Cocky"),
   _("Creamy"),
   _("Crisis"),
   _("Crusty"),
   _("Dark"),
   _("Deadly"),
   _("Deathly"),
   _("Defiant"),
   _("Delicious"),
   _("Despicable"),
   _("Destructive"),
   _("Diligent"),
   _("Drunk"),
   _("Egotistical"),
   _("Electromagnetic"),
   _("Erroneous"),
   _("Escaped"),
   _("Eternal"),
   _("Evil"),
   _("Fallen"),
   _("Fearless"),
   _("Fearsome"),
   _("Filthy"),
   _("Flightless"),
   _("Flying"),
   _("Foreboding"),
   _("Fuketeru"),
   _("Full-Motion"),
   _("Furchtlose"),
   _("General"),
   _("Gigantic"),
   _("Glittery"),
   _("Glorious"),
   _("Great"),
   _("Groß"),
   _("Grumpy"),
   _("Hairy"),
   _("Hammy"),
   _("Handsome"),
   _("Happy"),
   _("Hashitteru"),
   _("Hellen"),
   _("Hen'na"),
   _("Hidoi"),
   _("Hilarious"),
   _("Hitori No"),
   _("Horrible"),
   _("IDS"),
   _("Imperial"),
   _("Impressive"),
   _("Insatiable"),
   _("Ionic"),
   p_("name", "Iron"),
   _("Justice"),
   _("Kakkowarui"),
   _("Koronderu"),
   _("Kowai"),
   _("Lesser"),
   _("Lightspeed"),
   _("Lone"),
   _("Loud"),
   _("Lovely"),
   _("Lustful"),
   _("Mächtige"),
   _("Malodorous"),
   _("Messy"),
   _("Mighty"),
   _("Mijikai"),
   _("Morbid"),
   _("Mukashi No"),
   _("Murderous"),
   _("Nai"),
   _("Naïve"),
   _("Neutron-Accelerated"),
   _("New"),
   _("Night's"),
   _("Nimble"),
   _("Ninkyōna"),
   _("No Good"),
   _("Numb"),
   _("Oishī"),
   _("Ōkina"),
   _("Old"),
   _("Oshirisu No"),
   _("Oyoideru"),
   _("Pale"),
   _("Perilous"),
   _("Pirate's"),
   _("Pocket"),
   _("Princeless"),
   _("Psychic"),
   _("Raging"),
   _("Reclusive"),
   _("Relentless"),
   _("Rostige"),
   _("Rough"),
   _("Ruthless"),
   _("Saccharin"),
   _("Salty"),
   _("Samui"),
   _("Satanic"),
   _("Secluded"),
   _("Seltsame"),
   _("Serial"),
   _("Sharing"),
   _("Silly"),
   _("Single"),
   _("Sleepy"),
   _("Slimy"),
   _("Smelly"),
   _("Solar"),
   _("Space"),
   _("Stained"),
   _("Static"),
   _("Steel"),
   _("Strange"),
   _("Strawhat"),
   _("Sukina"),
   _("Super"),
   _("Sweaty"),
   _("Sweet"),
   _("Tall"),
   _("Takai"),
   _("Terrible"),
   _("Tired"),
   _("Toothless"),
   _("Tropical"),
   _("Tsukareteru"),
   _("Typical"),
   _("Ultimate"),
   _("Umai"),
   _("Uncombed"),
   _("Undead"),
   _("Unersättliche"),
   _("Unhealthy"),
   _("Unreal"),
   _("Unsightly"),
   _("Urusai"),
   _("Utsukushī"),
   _("Vengeful"),
   _("Very Bad"),
   p_("name", "Violent"),
   _("Warui"),
   _("Weeping"),
   _("Wild"),
   _("Winged"),
   _("Wretched"),
   _("Yaseteru"),
   _("Yasui"),
   _("Yasashī"),
   _("Yummy"),
}
local colours = {
   _("Akai"),
   _("Amarillo"),
   _("Aoi"),
   _("Azul"),
   _("Blau"),
   _("Bleu"),
   _("Blue"),
   _("Chairo No"),
   _("Crimson"),
   _("Cyan"),
   _("Gelb"),
   _("Gin'iro No"),
   _("Golden"),
   _("Gray"),
   _("Green"),
   _("Grün"),
   _("Haiiro No"),
   _("Kiiroi"),
   _("Kin'iro No"),
   _("Kuroi"),
   _("Mauve"),
   _("Midori No"),
   _("Murasaki No"),
   _("Pink"),
   _("Purple"),
   _("Red"),
   _("Roho"),
   _("Schwarz"),
   _("Shiroi"),
   _("Silver"),
   _("Violet"),
   _("Yellow"),
}
local actors = {
   _("1024"),
   _("Aku"),
   _("Akuma"),
   _("Alphabet Soup"),
   _("Amigo"),
   _("Angel"),
   _("Angle Grinder"),
   _("Anvil"),
   _("Ari"),
   _("Arrow"),
   p_("name", "Ass"),
   _("Atama"),
   _("Aunt"),
   _("Auster"),
   _("Avenger"),
   _("Axis"),
   _("Baka"),
   _("Bakemono"),
   _("Band Saw"),
   _("Bat"),
   _("Beard"),
   _("Belt Sander"),
   _("Bench Grinder"),
   _("Bengoshi"),
   _("Black Hole"),
   _("Blarg"),
   _("Blitzschneider"),
   _("Blizzard"),
   _("Blood"),
   _("Blunder"),
   _("Boot"),
   _("Bobber"),
   _("Bolt Cutter"),
   _("Bōshi"),
   _("Brain"),
   _("Breeze"),
   _("Bride"),
   _("Brigand"),
   _("Bulk"),
   _("Burglar"),
   _("Cane"),
   _("Chainsaw"),
   _("Cheese"),
   _("Cheese Grater"),
   _("Chi"),
   _("Chicken"),
   _("Circle"),
   _("Claw"),
   _("Claw Hammer"),
   _("Club"),
   _("Coconut"),
   _("Coot"),
   _("Corsair"),
   _("Cougar"),
   _("Crisis"),
   _("Crow"),
   _("Crowbar"),
   _("Crusader"),
   _("Curse"),
   _("Cyborg"),
   _("Darkness"),
   p_("name", "Death"),
   _("Deity"),
   _("Demon"),
   _("Destruction"),
   _("Devil"),
   _("Dictator"),
   _("Disaster"),
   _("Discord"),
   _("Donkey"),
   _("Doom"),
   _("Drache"),
   _("Dragon"),
   _("Dread"),
   _("Drifter"),
   _("Drill Press"),
   _("Duckling"),
   _("Eagle"),
   _("Eggplant"),
   _("Ego"),
   _("Electricity"),
   _("Emperor"),
   _("Energy-Volt"),
   _("Engine"),
   _("Fang"),
   _("Flare"),
   _("Flash"),
   _("Fox"),
   _("Friend"),
   _("Fugitive"),
   _("Gaki"),
   _("Geschützturmdrehbank"),
   _("Giant"),
   _("Gift"),
   _("Gohan"),
   _("Goose"),
   _("Gorilla"),
   _("Gun"),
   _("Hae"),
   _("Hamburger"),
   _("Hammer"),
   _("Headache"),
   _("Hex"),
   _("Hikari"),
   _("Horobi"),
   _("Horror"),
   p_("name", "Hunter"),
   _("Husband"),
   _("Ichigo"),
   _("Id"),
   _("Impact Wrench"),
   _("Inazuma"),
   _("Ionizer"),
   _("Ishi"),
   _("Itoyōji"),
   _("Jalapeño"),
   _("Jigsaw"),
   _("Jishin"),
   _("Jinx"),
   _("Ka"),
   _("Kailan"),
   _("Kaji"),
   _("Kamakiri"),
   _("Kame"),
   _("Kami"),
   _("Kamikaze"),
   _("Kappa"),
   _("Karaoke"),
   _("Katana"),
   _("Kaze"),
   _("Keel"),
   _("Ketchup"),
   _("Killer"),
   _("Kirin"),
   _("Kitchen Knife"),
   _("Kitsune"),
   _("Kitten"),
   _("Knave"),
   _("Knife"),
   _("Knight"),
   _("Kōmori"),
   _("Kumo"),
   _("Lance"),
   _("Lanze"),
   _("Lantern"),
   _("Lawyer"),
   _("League"),
   _("Lust"),
   _("Madōshi"),
   _("Magician"),
   _("Mahō"),
   _("Maize"),
   _("Mangaka"),
   _("Mangekyō"),
   _("Mango"),
   _("Mech"),
   _("Melon"),
   _("Mind"),
   _("Model"),
   _("Monster"),
   _("Mosquito"),
   _("Moustache"),
   _("Mugi"),
   _("Nanika"),
   _("Neckbeard"),
   _("Necromancer"),
   _("Neko"),
   _("Nezumi"),
   _("Night"),
   _("Niku"),
   _("Ninja"),
   _("Niwatori"),
   _("Nova"),
   _("Ogre"),
   p_("name", "Oni"),
   _("Onion"),
   _("Osiris"),
   p_("name", "Outlaw"),
   _("Oyster"),
   _("Panther"),
   _("Paste"),
   _("Pea"),
   _("Peapod"),
   _("Peril"),
   _("Pickaxe"),
   _("Pipe Wrench"),
   _("Pitchfork"),
   _("Politician"),
   _("Potato"),
   _("Potter"),
   _("Pride"),
   _("Princess"),
   _("Pulse"),
   _("Puppy"),
   _("Python"),
   _("Raigeki"),
   _("Ramen"),
   _("Rat"),
   _("Ratte"),
   _("Ravager"),
   _("Raven"),
   _("Reaver"),
   _("Recluse"),
   _("Rice"),
   _("Ring"),
   _("River"),
   _("Roba"),
   _("Rōjin"),
   _("Rubber Mallet"),
   _("Ryū"),
   _("Sakura"),
   _("Salad"),
   _("Samurai"),
   _("Sasori"),
   _("Scythe"),
   _("Sea"),
   _("Seaweed"),
   _("Seijika"),
   _("Sentinel"),
   _("Serpent"),
   _("Shepherd"),
   _("Shinigami"),
   _("Shinobi"),
   _("Shock"),
   _("Shovel"),
   _("Shujin"),
   _("Siren"),
   _("Slayer"),
   _("Space Dog"),
   _("Spade"),
   _("Spaghetti"),
   _("Spaghetti Monster"),
   _("Spider"),
   _("Squeegee"),
   _("Staple Gun"),
   _("Stern"),
   _("Stir-fry"),
   _("Storm"),
   _("Supernova"),
   _("Surströmming"),
   _("Table Saw"),
   _("Tallman"),
   _("Tanoshimi"),
   _("Tatsumaki"),
   _("Tegami"),
   _("Teineigo"),
   _("Tenkūryū"),
   _("Terror"),
   _("Thunder"),
   _("Tomodachi"),
   _("Tooth"),
   p_("name", "Tora"),
   p_("name", "Tori"),
   _("Treasure Hunter"),
   _("Tree"),
   _("Tsuchi"),
   _("Tumbler"),
   _("Turret Lathe"),
   _("Twilight"),
   _("Tyrant"),
   _("Umi"),
   _("Urchin"),
   _("Velocity"),
   _("Vengeance"),
   _("Void"),
   _("Vomit"),
   _("Wache"),
   _("Watcher"),
   _("Wedge"),
   _("Widget"),
   _("Widow"),
   _("Wight"), -- codespell:ignore wight
   _("Willow"),
   _("Wind"),
   _("Wizard"),
   _("Wolf"),
   _("Yakuza"),
   _("Yama"),
   _("Yami"),
   _("Yarou"),
   _("Yasai"),
   _("Yatsu"),
   _("Youma"),
   _("Zombie"),
}

--[[
-- @brief Generates pirate names
--]]
local function pirate ()
   local article = articles[ rnd.rnd(1,#articles) ]
   local descriptor = descriptors[ rnd.rnd(1,#descriptors) ]
   local colour = colours[ rnd.rnd(1,#colours) ]
   local actor = actors[ rnd.rnd(1,#actors) ]
   local params = {article=article, descriptor=descriptor, colour=colour, actor=actor}

   local r = rnd.rnd()
   if r < 0.166 then
      return fmt.f(_("{article} {actor}"), params)
   elseif r < 0.333 then
      return fmt.f(_("{colour} {actor}"), params)
   elseif r < 0.50 then
      return fmt.f(_("{descriptor} {actor}"), params)
   elseif r < 0.666 then
      return fmt.f(_("{article} {descriptor} {actor}"), params)
   elseif r < 0.833 then
      return fmt.f(_("{article} {colour} {actor}"), params)
   else
      return fmt.f(_("{article} {descriptor} {colour} {actor}"), params)
   end
end

return pirate
