/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class TaskMetadata {
    private final String taskId;
    private final Set<TopicPartition> topicPartitions;

    public TaskMetadata(String taskId, Set<TopicPartition> topicPartitions) {
        this.taskId = taskId;
        this.topicPartitions = Collections.unmodifiableSet(topicPartitions);
    }

    public String taskId() {
        return this.taskId;
    }

    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskMetadata that = (TaskMetadata)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.topicPartitions, that.topicPartitions);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.topicPartitions);
    }

    public String toString() {
        return "TaskMetadata{taskId=" + this.taskId + ", topicPartitions=" + this.topicPartitions + '}';
    }
}

