/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import org.campagnelab.goby.reads.PicardFastaIndexedSequence;
import org.campagnelab.goby.reads.RandomAccessSequenceCache;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;

public class DualRandomAccessSequenceCache
implements RandomAccessSequenceInterface {
    private RandomAccessSequenceInterface delegate;

    public void load(String filename) throws IOException, ClassNotFoundException {
        if (filename.endsWith(".fa") || filename.endsWith(".fasta")) {
            this.delegate = new PicardFastaIndexedSequence(filename);
        } else {
            RandomAccessSequenceCache gobyCache = new RandomAccessSequenceCache();
            gobyCache.load(filename);
            this.delegate = gobyCache;
        }
    }

    @Override
    public char get(int referenceIndex, int position) {
        return this.delegate.get(referenceIndex, position);
    }

    @Override
    public int getLength(int targetIndex) {
        return this.delegate.getLength(targetIndex);
    }

    @Override
    public void getRange(int referenceIndex, int position, int length, MutableString bases) {
        this.delegate.getRange(referenceIndex, position, length, bases);
    }

    @Override
    public int getReferenceIndex(String referenceId) {
        return this.delegate.getReferenceIndex(referenceId);
    }

    @Override
    public String getReferenceName(int index) {
        return this.delegate.getReferenceName(index);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

