/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMIndexer;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CRAMCRAIIndexer
implements CRAMIndexer {
    private final CRAIIndex craiIndex = new CRAIIndex();
    private final GZIPOutputStream os;

    public CRAMCRAIIndexer(OutputStream os, SAMFileHeader samHeader) {
        if (samHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException("CRAM file must be coordinate-sorted for indexing.");
        }
        try {
            this.os = new GZIPOutputStream(new BufferedOutputStream(os));
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error opening CRAI index output stream");
        }
    }

    public CRAMCRAIIndexer(OutputStream os, SAMFileHeader samHeader, Collection<CRAIEntry> entries) {
        this(os, samHeader);
        this.craiIndex.addEntries(entries);
    }

    public void processContainer(Container container) {
        this.craiIndex.processContainer(container);
    }

    @Override
    public void processContainer(Container container, ValidationStringency validationStringency) {
        this.processContainer(container);
    }

    @Override
    public void finish() {
        try {
            this.craiIndex.writeIndex(this.os);
            this.os.flush();
            this.os.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error writing CRAI index to output stream");
        }
    }

    public static void writeIndex(SeekableStream cramStream, OutputStream craiStream) {
        CramHeader cramHeader = CramIO.readCramHeader(cramStream);
        SAMFileHeader samFileHeader = Container.readSAMFileHeaderContainer(cramHeader.getCRAMVersion(), cramStream, null);
        if (samFileHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException(String.format("Input must be coordinate sorted (found %s) to create an index.", new Object[]{samFileHeader.getSortOrder()}));
        }
        CRAMCRAIIndexer indexer = new CRAMCRAIIndexer(craiStream, samFileHeader);
        CRAMVersion cramVersion = cramHeader.getCRAMVersion();
        try {
            Container container = new Container(cramVersion, cramStream, cramStream.position());
            while (container != null && !container.isEOF()) {
                indexer.processContainer(container);
                container = new Container(cramVersion, cramStream, cramStream.position());
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("error getting stream position", e);
        }
        indexer.finish();
    }

    public static CRAIIndex readIndex(InputStream is) {
        CRAIIndex craiIndex = new CRAIIndex();
        Scanner scanner = null;
        try {
            scanner = new Scanner(new GZIPInputStream(is));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                craiIndex.addEntry(new CRAIEntry(line));
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error reading CRAI index from output stream");
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
        return craiIndex;
    }
}

